#include "manager.h"


TString TMaintenanceConditionConstructor::BuildCondition(const TSet<TMaintenanceInfo::TId>& ids, NDrive::TEntitySession& session) {
    return "vin IN (" + session->Quote(ids) + ")";
}

NStorage::TTableRecord TMaintenanceConditionConstructor::BuildCondition(const TMaintenanceInfo::TId& id) {
    NStorage::TTableRecord trCondition;
    trCondition.Set("vin", id);
    return trCondition;
}

NStorage::TTableRecord TMaintenanceConditionConstructor::BuildCondition(const TMaintenanceInfo& object) {
    return BuildCondition(object.GetVIN());
}


TMaintenanceDB::TMaintenanceDB(const IHistoryContext& context)
    : TBase(context)
    , TDatabaseSessionConstructor(context.GetDatabase())
{
}

bool TMaintenanceDB::UpsertMaintenanceInfo(const TMaintenanceInfo& info, const TString& operatorUserId, bool force, NDrive::TEntitySession& session) const {
    auto infos = GetObjects({ info.GetVIN() }, session);
    if (!infos) {
        return false;
    }
    if (infos->size()) {
        if (!force) {
            if (infos->front() < info) {
                session.SetErrorInfo("UpsertMaintenanceInfo", "cannot set such value", EDriveSessionResult::IncorrectRequest);
                return false;
            }
        }
        if (infos->front().IsEqual(info)) {
            return true;
        }
        if (infos->front().GetSource() != info.GetSource()) {
            if (infos->front() < info) {
                return true;
            }
        }
    }
    if (!UpsertObject(info, operatorUserId, session)) {
        return false;
    }
    return true;
}
