#pragma once

#include "entity.h"

#include <drive/backend/database/history/db_entities.h>


class TMaintenanceConditionConstructor {
public:
    static TString BuildCondition(const TSet<TMaintenanceInfo::TId>& ids, NDrive::TEntitySession& session);
    static NStorage::TTableRecord BuildCondition(const TMaintenanceInfo::TId& id);
    static NStorage::TTableRecord BuildCondition(const TMaintenanceInfo& object);
};

class TMaintenanceDB
    : public TDatabaseEntitiesManager<TMaintenanceInfo, TMaintenanceConditionConstructor>
    , public TDatabaseSessionConstructor
{
private:
    using TBase = TDatabaseEntitiesManager<TMaintenanceInfo, TMaintenanceConditionConstructor>;

public:
    TMaintenanceDB(const IHistoryContext& context);
    bool UpsertMaintenanceInfo(const TMaintenanceInfo& info, const TString& operatorUserId, bool force, NDrive::TEntitySession& session) const;
};
