#pragma once
#include "config.h"
#include "entities.h"
#include "logger.h"

#include <drive/backend/maintenance/manager.h>

#include <util/string/vector.h>

class TMajorClient {
public:
    TMajorClient(const TMajorClientConfig& config);
    ~TMajorClient();

    bool GetTypeQueryList(TVector<NMajorClient::TTypeQueryRequest::TType>& queryList, TMessagesCollector& errors) const;
    bool GetQueryList(bool closed, TVector<NMajorClient::TGetQueriesRequest::TQuery>& queryList, TMessagesCollector& errors) const;
    bool GetAllQueryList(TVector<NMajorClient::TGetQueriesRequest::TQuery>& queryList, TMessagesCollector& errors) const;
    bool CreateQuery(const NMajorClient::TCreateQueryRequest::TQuery& query, NMajorClient::TCreateQueryRequest::TResponse& answer, TMessagesCollector& errors) const;
    bool CancelQuery(const TString& id, TMessagesCollector& errors) const;
    bool GetQueryInfo(const TString& id, NMajorClient::TQueryInfoRequest::TFullQueryInfo& parameterList, TMessagesCollector& errors) const;
    bool GetQueryHistoryInfo(const TString& id, NMajorClient::THistoryInfoRequest::TInfoWithHistory& parameterList, TMessagesCollector& errors) const;
    bool GetStatus(const TString& id, TString& status, bool& isClosed, TMessagesCollector& errors) const;
    bool GetFiles(const TString& id, const TSet<TString>& extensions, TVector <NMajorClient::TGetFileRequest::TMajorFile> & files, TMessagesCollector& errors) const;
    bool GetOSAGO(const TString& vin, const bool isCurrent, NMajorClient::TOSAGORequest::TOSAGODocument& osago, TMessagesCollector& errors) const;
    bool CreateSTSRequest(const TString& vin, NMajorClient::TSTSRequest::TResponse& commonResponse, TMessagesCollector& errors) const;
    bool GetOrUpdateToken(TString& token, TMessagesCollector& errors) const;

    bool GetMaintenanceInfo(TVector<TMaintenanceInfo>& info, TMessagesCollector& errors) const;


    bool GetTyreServiceInfo(NMajorClient::TTyreServiceInfoRequest::TTyreServiceInfo& info, const TInstant since, const TInstant until, TMessagesCollector& errors) const;
    bool GetReservedInfo(TVector<NMajorClient::TCarInfo>& info, TMessagesCollector& errors) const;
    bool GetAllCarInfo(TVector<NMajorClient::TIssuedCarInfo>& info, TMessagesCollector& errors) const;

    bool GetCarPenalties(const TString& vin, NMajorClient::TCarPenaltiesRequest::EPenaltyCheckPolicy policy, TVector<NMajorClient::TCarPenaltiesRequest::TCarPenaltyInfo>& penalties, TMessagesCollector& errors, const TMaybe<ui64> lastReceivedID = {}) const;
    bool GetCarPenalties(const TVector<TString>& vins, NMajorClient::TCarPenaltiesRequest::EPenaltyCheckPolicy policy, TVector<NMajorClient::TCarPenaltiesRequest::TCarPenaltyInfo>& penalties, TMessagesCollector& errors, const TMaybe<ui64> lastReceivedID = {}) const;

    bool GetCarPenaltyDecree(const i64 externalId, NMajorClient::TCarPenaltyDecreeRequest::TCarPenaltyDecree& penaltyDecree, TMessagesCollector& errors) const;
    bool GetCarPenaltyDecree(const TString& rulingNumber, NMajorClient::TCarPenaltyDecreeRequest::TCarPenaltyDecree& penaltyDecree, TMessagesCollector& errors) const;

    bool GetLastTyreService(const TVector<TString>& vins, TVector<NMajorClient::TLastTyreServiceRequest::TInfo>& infos, TMessagesCollector& errors) const;

    bool GetTyreStorageInfo(const TVector<NMajorClient::ETyreRegion>& regions, NMajorClient::ETyreStorageType storageType, NMajorClient::TTyreStorageInfoRequest::TInfo& info, TMessagesCollector& errors) const;
    bool GetTyreFiles(const TString& vin, NMajorClient::ETyreFileStatus status, TVector<NMajorClient::TTyreFilesRequest::TFile>& files, TMessagesCollector& errors) const;

private:
    bool SendRequest(const TString& uri, NMajorClient::IMajorRequest& request, bool auth = true) const;

    bool GetCarPenaltyDecree(const TMaybe<i64>& externalId, const TMaybe<TString>& rulingNumber, NMajorClient::TCarPenaltyDecreeRequest::TCarPenaltyDecree& penaltyDecree, TMessagesCollector& errors) const;

private:
    const TMajorClientConfig Config;
    const TMajorLogger Logger;
    mutable TString Token;
    mutable TInstant TokenDeadline;
    mutable TRWMutex Mutex;
};
