#include "config.h"

#include <util/stream/file.h>

void TMajorClientConfig::Init(const TYandexConfig::Section* section) {
    UserName = section->GetDirectives().Value("UserName", UserName);
    Password = section->GetDirectives().Value("Password", Password);
    PasswordPath = section->GetDirectives().Value("PasswordPath", PasswordPath);
    if (!Password && PasswordPath) {
        Password = Strip(TFileInput(PasswordPath).ReadAll());
    }

    Host = section->GetDirectives().Value("Host", Host);
    Port = section->GetDirectives().Value<ui16>("Port", Port);
    Https = section->GetDirectives().Value<bool>("Https", Https);
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    AttemptionsMax = section->GetDirectives().Value<ui32>("AttemptionsMax", AttemptionsMax);
    auto children = section->GetAllChildren();
    auto itHistoryConfig = children.find("HistoryConfig");
    if (itHistoryConfig != children.end()) {
        HistoryConfig.Init(itHistoryConfig->second);
    }

    CreateAPIPath = section->GetDirectives().Value("CreateAPIPath", CreateAPIPath);
    CommonCreateAPIPath = section->GetDirectives().Value("CommonCreateAPIPath", CommonCreateAPIPath);
    TypeAPIPath = section->GetDirectives().Value("TypeAPIPath", TypeAPIPath);
    QueriesAPIPath = section->GetDirectives().Value("QueriesAPIPath", QueriesAPIPath);
    InfoAPIPath = section->GetDirectives().Value("InfoAPIPath", InfoAPIPath);
    CommonHistoryAPIPath = section->GetDirectives().Value("CommonHistoryAPIPath", CommonHistoryAPIPath);
    FileListAPIPath = section->GetDirectives().Value("FileListAPIPath", FileListAPIPath);
    FileAPIPath = section->GetDirectives().Value("FileAPIPath", FileAPIPath);
    CancelAPIPath = section->GetDirectives().Value("CancelAPIPath", CancelAPIPath);
    OSAGOAPIPath = section->GetDirectives().Value("OSAGOAPIPath", OSAGOAPIPath);
    TokenAPIPath = section->GetDirectives().Value("TokenAPIPath", TokenAPIPath);
    MaintenanceInfoAPIPath = section->GetDirectives().Value("MaintenanceInfoAPIPath", MaintenanceInfoAPIPath);
    TyreServiceInfoAPIPath = section->GetDirectives().Value("TyreServiceInfoAPIPath", TyreServiceInfoAPIPath);
    TyreStorageInfoAPIPath = section->GetDirectives().Value("TyreStorageInfoAPIPath", TyreStorageInfoAPIPath);
    LastTyreServiceAPIPath = section->GetDirectives().Value("LastTyreServiceAPIPath", LastTyreServiceAPIPath);
    TyreFilesAPIPath = section->GetDirectives().Value("TyreFilesAPIPath", TyreFilesAPIPath);
    ReservedInfoAPIPath = section->GetDirectives().Value("ReservedInfoAPIPath", ReservedInfoAPIPath);
    IssuedCarInfoAPIPath = section->GetDirectives().Value("IssuedCarInfoAPIPath", IssuedCarInfoAPIPath);
    CarPenaltiesAPIPath = section->GetDirectives().Value("CarPenaltiesAPIPath", CarPenaltiesAPIPath);
    CarPenaltyDecreeAPIPath = section->GetDirectives().Value("CarPenaltyDecreeAPIPath", CarPenaltyDecreeAPIPath);

    ContactFIO = section->GetDirectives().Value("ContactFIO", ContactFIO);
    ContactPhone = section->GetDirectives().Value("ContactPhone", ContactPhone);
    QueryType = section->GetDirectives().Value("QueryType", QueryType);
    STSType = section->GetDirectives().Value("STSType", STSType);
}

void TMajorClientConfig::ToString(IOutputStream& os) const {
    os << "UserName: " << UserName << Endl;
    os << "PasswordPath: " << PasswordPath << Endl;

    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "Https: " << Https << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;
    os << "AttemptionsMax: " << AttemptionsMax << Endl;

    os << "<HistoryConfig>" << Endl;
    HistoryConfig.ToString(os);
    os << "</HistoryConfig>" << Endl;

    os << "CreateAPIPath: " << CreateAPIPath << Endl;
    os << "CommonCreateAPIPath: " << CommonCreateAPIPath << Endl;
    os << "TypeAPIPath: " << TypeAPIPath << Endl;
    os << "QueriesAPIPath: " << QueriesAPIPath << Endl;
    os << "InfoAPIPath: " << InfoAPIPath << Endl;
    os << "CommonHistoryAPIPath: " << CommonHistoryAPIPath << Endl;
    os << "FileListAPIPath: " << FileListAPIPath << Endl;
    os << "FileAPIPath: " << FileAPIPath << Endl;
    os << "CancelAPIPath: " << CancelAPIPath << Endl;
    os << "OSAGOAPIPath: " << OSAGOAPIPath << Endl;
    os << "TokenAPIPath: " << TokenAPIPath << Endl;
    os << "MaintenanceInfoAPIPath: " << MaintenanceInfoAPIPath << Endl;
    os << "TyreServiceInfoAPIPath: " << TyreServiceInfoAPIPath << Endl;
    os << "TyreStorageInfoAPIPath: " << TyreStorageInfoAPIPath << Endl;
    os << "LastTyreServiceAPIPath: " << LastTyreServiceAPIPath << Endl;
    os << "TyreFilesAPIPath: " << TyreFilesAPIPath << Endl;
    os << "ReservedInfoAPIPath: " << ReservedInfoAPIPath << Endl;
    os << "IssuedCarInfoAPIPath: " << IssuedCarInfoAPIPath << Endl;
    os << "CarPenaltiesAPIPath: " << CarPenaltiesAPIPath << Endl;
    os << "CarPenaltyDecreeAPIPath: " << CarPenaltyDecreeAPIPath << Endl;

    os << "ContactFIO: " << ContactFIO << Endl;
    os << "ContactPhone: " << ContactPhone << Endl;
    os << "QueryType: " << QueryType << Endl;
    os << "STSType: " << STSType << Endl;
}
