#pragma once
#include <drive/backend/database/history/config.h>

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/logger/global/global.h>

#include <rtline/util/types/accessor.h>

#include <util/datetime/base.h>

const ui64 DEFAULT_QUERY_TYPE = 284103496696123;
const ui64 STS_QUERY_TYPE = 284103496696150;

class TMajorClientConfig {
    R_READONLY(TString, Host);
    R_READONLY(ui16, Port, 80);
    R_READONLY(bool, Https, false);
    R_READONLY(TString, UserName);
    R_READONLY(TString, PasswordPath);
    R_READONLY(TString, Password);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(60));
    R_READONLY(TString, CreateAPIPath, "/MASP/api1/LEAD/Create");
    R_READONLY(TString, CommonCreateAPIPath, "/MASP/api1/LEADCommon/Create");
    R_READONLY(TString, TypeAPIPath, "/MASP/api1/LEAD/ReadTypeQueryList");
    R_READONLY(TString, QueriesAPIPath, "/MASP/api1/LEAD/ReadQueryList");
    R_READONLY(TString, InfoAPIPath, "/MASP/api1/LEAD/ReadQuery");
    R_READONLY(TString, CommonHistoryAPIPath, "/MASP/api1/LEAD/ReadQueryStatusHst");
    R_READONLY(TString, CancelAPIPath, "/MASP/api1/LEAD/CancelQuery");
    R_READONLY(TString, OSAGOAPIPath, "/MASP/api1/LS/ReadEOSAGO");
    R_READONLY(TString, FileListAPIPath, "/MASP/api1/LEAD/ReadFileList");
    R_READONLY(TString, FileAPIPath, "/MASP/api1/LEAD/ReadFile");
    R_READONLY(TString, TokenAPIPath, "/Auth/GetToken");
    R_READONLY(TString, MaintenanceInfoAPIPath, "/MASP/api1/LSCar/ReadLastMaintenance");
    R_READONLY(TString, TyreServiceInfoAPIPath, "/MASP/api1/TyreService/ReadQuery");
    R_READONLY(TString, TyreStorageInfoAPIPath, "/MASP/api1/TyreService/Storage");
    R_READONLY(TString, LastTyreServiceAPIPath, "/MASP/api1/TyreReplacement/CarInfo");
    R_READONLY(TString, TyreFilesAPIPath, "/MASP/api1/TyreReplacement/Photo");
    R_READONLY(TString, ReservedInfoAPIPath, "/MASP/api1/LSCar/ReadReserved");
    R_READONLY(TString, IssuedCarInfoAPIPath, "/MASP/api1/LSCar/ReadDict");
    R_READONLY(TString, CarPenaltiesAPIPath, "/MASP/api1/LSCar/ReadPenalty");
    R_READONLY(TString, CarPenaltyDecreeAPIPath, "/MASP/api1/LS/ReadPenaltyDecree");
    R_READONLY(TString, ContactFIO);
    R_READONLY(TString, ContactPhone);
    R_READONLY(ui64, QueryType, DEFAULT_QUERY_TYPE);
    R_READONLY(ui64, STSType, STS_QUERY_TYPE);
    R_READONLY(ui32, AttemptionsMax, 1);
private:
    THistoryConfig HistoryConfig;
public:

    const THistoryConfig& GetHistoryConfig() const {
        return HistoryConfig;
    }

    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TMajorClientConfig ParseFromString(const TString& configStr) {
        TMajorClientConfig result;
        TAnyYandexConfig config;
        CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
        result.Init(config.GetRootSection());
        return result;
    }
};
