#pragma once

#include <rtline/library/deprecated/async_impl/logger.h>

enum EMajorOperationType {
    GetTypeRequest /* "get_query_types" */,
    GetQueriesRequest /* "get_queries" */,
    CreateQuery /* "create_query" */,
    CancelQuery /* "cancel_query" */,
    GetInfo /* "get_query_info" */,
    UpdateToken /* "update_token" */,
    RequestOSAGO /* "request_osago" */,
    RequestSTS /* "request_sts" */,
    GetFileList /* "get_file_list" */,
    GetFile /* "get_file_list" */,
    GetMaintenanceInfo /* "get_maintenance_info" */,
    GetTyreServiceInfo /* "get_tyre_service_info" */,
    GetTyreStorageInfo /* "get_tyre_storage_info" */,
    GetLastTyreServiceInfo /* "get_last_tyre_service_info" */,
    GetTyreFiles /* "get_tyre_files" */,
    GetReservedInfo /* "get_reserved_info" */,
    GetIssuedCarsInfo /* "get_issued_cars" */,
    GetCarPenalties /* "get_car_penalties" */,
    GetCarPenaltyDecree /* "get_car_penalty_decree" */,
};

class TMajorLogger : public TRequestLogger<EMajorOperationType> {
    using TBase = TRequestLogger<EMajorOperationType>;
public:
    TMajorLogger(const TString& source)
        : TBase(source, "drive-frontend-major")
    {
    }
};
