#include <drive/backend/major/client.h>
#include <drive/backend/major/config.h>

#include <drive/backend/ut/library/helper.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/string/builder.h>
#include <util/system/env.h>

namespace {
    TMajorClientConfig GetMajorConfig() {
        auto config = TMajorClientConfig::ParseFromString(
            TStringBuilder()
            << "Host: b2btest.ma.ru" << Endl
            << "Https: 1" << Endl
            << "Port: 443" << Endl
            << "UserName: yandex_api" << Endl
            << "PasswordPath: " << GetEnv("TESTING_MAJOR_PASSWORD_PATH") << Endl
            << "RequestTimeout: 180s" << Endl
        );
        return config;
    }
}

Y_UNIT_TEST_SUITE(MajorClient) {
    Y_UNIT_TEST(GetCarPenalties) {
        using TCarPenaltyInfo = NMajorClient::TCarPenaltiesRequest::TCarPenaltyInfo;

        auto client = TMajorClient(GetMajorConfig());

        const TVector<TString> vins = { "XW8AN2NE9KH026143", "SALYA2BX1KA208965" };
        auto policy = NMajorClient::TCarPenaltiesRequest::EPenaltyCheckPolicy::NotPaid;

        TVector<TCarPenaltyInfo> penalties;
        TMessagesCollector errors;
        UNIT_ASSERT_C(client.GetCarPenalties(vins, policy, penalties, errors), errors.GetStringReport());

        Cerr << "Total penalties: " << penalties.size() << Endl;
    }
}
