CREATE TABLE IF NOT EXISTS signals_configuration (
    id uuid PRIMARY KEY DEFAULT (uuid_generate_v4()),
    owner TEXT,
    type TEXT NOT NULL,
    revision BIGSERIAL NOT NULL,
    meta json
);
CREATE TABLE IF NOT EXISTS zone (
    id uuid PRIMARY KEY DEFAULT (uuid_generate_v4()),
    owner TEXT,
    name TEXT NOT NULL,
    revision BIGSERIAL NOT NULL,
    meta json,

    FOREIGN KEY(owner) REFERENCES "tags_description"(name),
    UNIQUE(owner, name)
);
CREATE TABLE IF NOT EXISTS entity_references (
    id uuid PRIMARY KEY DEFAULT (uuid_generate_v4()),
    timestamp integer NOT NULL,

    entity_name text,
    entity_id text,

    zone_id uuid Default NULL,
    named_filters_id uuid Default NULL,
    signal_configuration_id uuid Default NULL,
    notifier_id text Default NULL,
    models_id text Default NULL,

    FOREIGN KEY(zone_id) REFERENCES "zone"(id),
    FOREIGN KEY(named_filters_id) REFERENCES "named_filters"(id),
    FOREIGN KEY(signal_configuration_id) REFERENCES "signals_configuration"(id),
    FOREIGN KEY(notifier_id) REFERENCES "notifiers"(name),
    FOREIGN KEY(models_id) REFERENCES "car_model"(code)
);
