/* nosqlite */CREATE TYPE entity_type AS ENUM (
    'car',
    'trace'
);
CREATE TABLE IF NOT EXISTS signals (
    id uuid PRIMARY KEY,
    name text NOT NULL,
    type entity_type NOT NULL,

    object_id uuid,
    session_id uuid,
    user_id uuid,

    resolution text,
    start integer NOT NULL,
    finish integer,
    visible boolean
);
/* nosqlite */CREATE INDEX IF NOT EXISTS signals_name_index ON signals USING btree(name);
/* nosqlite */CREATE INDEX IF NOT EXISTS signals_start_index ON signals USING btree(start);
/* nosqlite */CREATE INDEX IF NOT EXISTS signals_object_id_index ON signals USING btree(object_id);
/* nosqlite */CREATE INDEX IF NOT EXISTS signals_session_id_index ON signals USING btree(session_id);
/* nosqlite */CREATE INDEX IF NOT EXISTS signals_user_id_index ON signals USING btree(user_id);
