#pragma once

#include "fwd.h"

#include <rtline/util/auto_actualization.h>

#include <util/generic/map.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/system/rwlock.h>

namespace NRTLine {
    class IVersionedStorage;
}

namespace NDrive {
    class TModelsStorage: protected IAutoActualization {
    public:
        TModelsStorage(TAtomicSharedPtr<NRTLine::IVersionedStorage> storage);
        ~TModelsStorage();

        TOfferModelConstPtr AddOfferModel(TOfferModelPtr model);
        TOfferModelConstPtr GetOfferModel(TStringBuf name) const;
        TOptionalOfferMultiModel GetOfferMultiModel(TConstArrayRef<TString> names) const;
        TVector<TString> ListOfferModels() const;
        bool RemoveOfferModel(TStringBuf name) const;

    protected:
        virtual bool Refresh() override;

    private:
        struct TVersionedModel {
            TOfferModelPtr Model;
            i64 Version = -1;

            explicit operator bool() const {
                return static_cast<bool>(Model);
            }
        };

    private:
        TString GetModelPath(TStringBuf name) const;
        TString GetModelRoot() const;
        i64 GetModelVersion(TStringBuf name) const;
        TVersionedModel TryCreateOfferModel(TStringBuf name) const;

    private:
        TAtomicSharedPtr<NRTLine::IVersionedStorage> Storage;
        mutable TMap<TString, TVersionedModel> OfferModelsCache;

        TRWMutex Lock;
    };
}
