#include "internal.h"
#include <library/cpp/logger/global/global.h>
#include <util/string/join.h>

void TInternalNotifier::DoStart(const IServerBase* /*server*/) {
}

NDrive::INotifier::TResult::TPtr TInternalNotifier::DoNotify(const TMessage& message, const TContext& context) const {
    const TRecipients& recipients = context.GetRecipients();
    for (size_t i = 0; i < recipients.size(); ++i) {
        SendGlobalMessage<TInternalNotificationMessage>(recipients[i].GetUid(), message.GetBody());
    }
    return nullptr;
}

void TInternalNotifier::DoStop() {
}

TInternalNotifierConfig::TFactory::TRegistrator<TInternalNotifierConfig> TInternalNotifierConfig::Registrator("internal");


NDrive::INotifier::TPtr TInternalNotifierConfig::Construct() const {
    return new TInternalNotifier(*this);
}
