#pragma once
#include <drive/backend/abstract/notifier.h>

class TInternalNotifierConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;
    static TFactory::TRegistrator<TInternalNotifierConfig> Registrator;

public:
    virtual NDrive::INotifier::TPtr Construct() const override;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override {
        return TBase::DeserializeFromJson(info, errors);
    }

    virtual NJson::TJsonValue SerializeToJson() const override {
        NJson::TJsonValue result = TBase::SerializeToJson();
        return result;
    }

    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override {
        NDrive::TScheme result = TBase::GetScheme(server);
        return result;
    }

private:
    virtual void DoInit(const TYandexConfig::Section* /*section*/) override {
//        LogPriority = section->GetDirectives().Value("LogPriority", LogPriority);
    }

    virtual void DoToString(IOutputStream& /*os*/) const override {
//        os << "LogPriority: " << LogPriority << Endl;
    }
};

class TInternalNotifier: public NDrive::INotifier, public TNonCopyable {
private:
    const TInternalNotifierConfig Config;

public:
    TInternalNotifier(const TInternalNotifierConfig& config)
        : NDrive::INotifier(config)
        , Config(config)
    {}

    virtual void DoStart(const IServerBase* /*server*/) override;

    virtual void DoStop() override;

private:
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;
};
