#include "logs_notifier.h"
#include <library/cpp/logger/global/global.h>
#include <util/string/join.h>

void TLogsNotifier::DoStart(const IServerBase* /*server*/) {
}

NDrive::INotifier::TResult::TPtr TLogsNotifier::DoNotify(const TMessage& message, const TContext& context) const {
    TString recipientsStr;

    const TRecipients& recipients = context.GetRecipients();

    for (size_t i = 0; i < recipients.size(); ++i) {
        const TUserContacts& contact = recipients[i];
        recipientsStr += contact.GetEmail() + ":" + contact.GetUid();
        if (i != recipients.size() - 1) {
            recipientsStr += ", ";
        }
    }

    TEMPLATE_LOG(Config.GetLogPriority())
        << ((message.GetTitle()) ? message.GetTitle() + " - " : "")
        << ((message.GetHeader()) ? message.GetHeader() + ": " : "")
        << message.GetBody()
        << recipientsStr
        << Endl;
    return nullptr;
}

void TLogsNotifier::DoStop() {
}

TLogsNotifierConfig::TFactory::TRegistrator<TLogsNotifierConfig> TLogsNotifierConfig::Registrator("logs");


NDrive::INotifier::TPtr TLogsNotifierConfig::Construct() const {
    return new TLogsNotifier(*this);
}
