#pragma once
#include <drive/backend/abstract/notifier.h>

class TLogsNotifierConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;
    ELogPriority LogPriority = TLOG_DEBUG;
    static TFactory::TRegistrator<TLogsNotifierConfig> Registrator;

public:
    ELogPriority GetLogPriority() const {
        return LogPriority;
    }

    virtual NDrive::INotifier::TPtr Construct() const override;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override {
        JREAD_FROM_STRING_OPT(info, "log_priority", LogPriority);
        return TBase::DeserializeFromJson(info, errors);
    }

    virtual NJson::TJsonValue SerializeToJson() const override {
        NJson::TJsonValue result = TBase::SerializeToJson();
        JWRITE_ENUM(result, "log_priority", LogPriority);
        return result;
    }

    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override {
        NDrive::TScheme result = TBase::GetScheme(server);
        result.Add<TFSVariants>("log_priority").InitVariants<ELogPriority>();
        return result;
    }

private:
    virtual void DoInit(const TYandexConfig::Section* section) override {
        LogPriority = section->GetDirectives().Value("LogPriority", LogPriority);
    }

    virtual void DoToString(IOutputStream& os) const override {
        os << "LogPriority: " << LogPriority << Endl;
    }
};

class TLogsNotifier: public NDrive::INotifier, public TNonCopyable {
private:
    const TLogsNotifierConfig Config;

public:
    TLogsNotifier(const TLogsNotifierConfig& config)
        : NDrive::INotifier(config)
        , Config(config)
    {}

    virtual void DoStart(const IServerBase* /*server*/) override;

    virtual void DoStop() override;

private:
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context) const override;
};
