#pragma once

#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>
#include <library/cpp/string_utils/url/url.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>
#include <rtline/util/types/accessor.h>

#include <util/stream/file.h>

class TAccountEmailBinderConfig {
    R_READONLY(TString, Host, "passport-internal.yandex.ru");
    R_READONLY(ui32, Port, 443);

    R_READONLY(TString, Consumer, "y.drive-sessions");
    R_READONLY(TString, Language, "ru");
    R_READONLY(TString, ValidatorUiUrl, "https://passport.yandex.ru");
    R_READONLY(TString, RetPath, "https://passport.yandex.ru");
    R_READONLY(TString, SubmitUri, "/1/bundle/email/send_confirmation_email/");
    R_READONLY(TString, CommitUri, "/1/bundle/email/confirm/by_code/");

    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);

    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    static TAccountEmailBinderConfig ParseFromString(const TString& configStr);
};
class TAccountEmailBinder {
private:
    TAccountEmailBinderConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;

public:
    TAccountEmailBinder(const TAccountEmailBinderConfig& config, const TAtomicSharedPtr<NTvmAuth::TTvmClient>& tvmClient)
        : Config(config)
        , AD(new TAsyncDelivery())
        , Agent(new NNeh::THttpClient(AD))
        , Tvm(tvmClient)
    {
        AD->Start(Config.GetRequestConfig().GetThreadsStatusChecker(), Config.GetRequestConfig().GetThreadsSenders());
        Agent->RegisterSource("mail-binder", Config.GetHost(), Config.GetPort(), Config.GetRequestConfig(), true);
    }
    ~TAccountEmailBinder() {
        AD->Stop();
    }
    bool BindSubmit(const TString& email, TString& token, const TString& userAuthHeader, const TString& clientIp, TString& error) const;
    bool ConfirmCode(const TString& key, const TString& token, const TString& userAuthHeader, const TString& clientIp, TString& error) const;

private:
    bool SendRequest(const TString& cgi, TString& token, const TString& uri, const TString& userAuthHeader, const TString& clientIp, TString& error) const;
    bool SendRequest(const TString& cgi, const TString& token, const TString& uri, const TString& userAuthHeader, const TString& clientIp, TString& error) const;
    bool CreateTrack(TString& trackId) const;
};
