#pragma once

#include <drive/backend/abstract/notifier.h>

#include <rtline/library/metasearch/simple/config.h>

namespace NNeh {
    class THttpClient;
}

class TAsyncDelivery;

class TMailNotificationsConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;
    R_READONLY(TString, Host);
    R_READONLY(ui16, Port, 443);
    R_READONLY(bool, IsHttps, true);
    R_READONLY(TString, AuthToken);
    R_READONLY(TString, Account);
    R_READONLY(TString, OverridenRecipient);
    R_READONLY(ui32, MaxInFlight, 10);
    R_READONLY(TDuration, ResponseTimeout, TDuration::Seconds(10));

public:
    void DoInit(const TYandexConfig::Section* section) override;
    void DoToString(IOutputStream& os) const override;
    NDrive::INotifier::TPtr Construct() const override;

    bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    static TFactory::TRegistrator<TMailNotificationsConfig> Registrator;
};

// TMailNotifier uses  sender.yandex-team.ru that is based on templates.
// So messages for TMailNotifier must contain tamplate id (sender compaign_id)
// in |Header| and serialized json with template arguments in |Body|.
// Refer to docs here: https://wiki.yandex-team.ru/sender/
//     Direct link: https://github.yandex-team.ru/sendr/sendr/blob/master/docs/transaction-api.md
class TMailNotifier: public NDrive::INotifier {
private:
    const TMailNotificationsConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;

public:
    TMailNotifier(const TMailNotificationsConfig& config);
    ~TMailNotifier() override;

    void DoStart(const IServerBase* /*server*/) override;
    void DoStop() override;

private:
    TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;
};
