#pragma once

#include <drive/backend/abstract/localization.h>
#include <drive/backend/chat/engine.h>
#include <drive/backend/chat_robots/ifaces.h>
#include <drive/backend/chat_robots/configuration/config.h>

#include <kernel/daemon/config/daemon_config.h>

class TChatRobotNotifierConfig : public TChatRobotConfig {
private:
    using TBase = TChatRobotConfig;

public:
    virtual NDrive::INotifier::TPtr Construct() const override;

    bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    static TFactory::TRegistrator<TChatRobotNotifierConfig> Registrator;
};

class TNativeChatMessage : public NDrive::INotifier::TMessage {
    using TBase = NDrive::INotifier::TMessage;

public:
    TNativeChatMessage()
        : TBase("", "")
    {
    }

    TNativeChatMessage(const TString& topic, const NDrive::NChat::TMessage& chatMessage)
        : TBase("", "")
        , Topic(topic)
        , ChatMessage(chatMessage)
    {
    }

    virtual void DoSerializeToJson(NJson::TJsonValue& result) const override;
    virtual bool DoDeserializeFromJson(const NJson::TJsonValue& data) override;

private:
    R_READONLY(TString, Topic);
    R_READONLY(NDrive::NChat::TMessage, ChatMessage);
};

class TNativeChatNotifier: public NDrive::INotifier {
    using TBase = NDrive::INotifier;

public:
    using TNativeChatMessage = TNativeChatMessage;

    TNativeChatNotifier(const TChatRobotNotifierConfig& config);
    virtual ~TNativeChatNotifier() override;

    const TChatRobotNotifierConfig& GetConfig() const noexcept {
        return Config;
    }

    void DoStart(const IServerBase* server) override;
    void DoStop() override;

    NJson::TJsonValue GetDescriptor(const TString& userId, const TString& topic) const;

private:
    bool EnsureInitialized(const NDrive::IServer* server) const;

    virtual TMessage::TPtr ConstructMessage(const NJson::TJsonValue& messageData) const override;
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;

    const TChatRobotNotifierConfig Config;

    TRWMutex MutexInit;
    mutable bool IsRobotInitialized = false;
};
