#pragma once
#include <drive/backend/abstract/notifier.h>

class TNullNotifierConfig: public NDrive::INotifierConfig {
private:
    static TFactory::TRegistrator<TNullNotifierConfig> Registrator;

public:
    virtual NDrive::INotifier::TPtr Construct() const override;

private:
    virtual void DoInit(const TYandexConfig::Section* /*section*/) override {
    }

    virtual void DoToString(IOutputStream& /*os*/) const override {
    }
};

class TNullNotifier: public NDrive::INotifier, public TNonCopyable {
private:
    const TNullNotifierConfig Config;

public:
    TNullNotifier(const TNullNotifierConfig& config)
        : NDrive::INotifier(config)
        , Config(config)
    {
    }

    virtual void DoStart(const IServerBase* /*server*/) override;

    virtual void DoStop() override;

private:
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;
};
