#pragma once

#include <drive/backend/abstract/notifier.h>

#include <library/cpp/yconf/conf.h>

#include <rtline/library/async_proxy/async_delivery.h>
#include <rtline/library/metasearch/simple/config.h>
#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <util/generic/ptr.h>
#include <util/stream/output.h>
#include <util/string/vector.h>

namespace NNeh {
    class THttpClient;
}

class TAsyncDelivery;

class TPushNotificationsConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;

private:
    R_READONLY(TString, Host, "push.yandex.ru");
    R_READONLY(ui16, Port, 443);
    R_READONLY(bool, IsHttps, true);
    R_READONLY(TString, Uri, "v2/batch_send");
    R_READONLY(TString, AuthToken);
    R_READONLY(TFsPath, TokenPath);
    R_READONLY(TString, EventType, "push");

    R_READONLY(TString, ServiceName, "carsharing");
    R_READONLY(TString, SubscriptionUri, "v2/subscribe/app");
    R_READONLY(TString, SubscriptionToken);
    R_READONLY(TFsPath, SubscriptionTokenPath);
    R_READONLY(bool, ContentAvailable, false);
    R_READONLY(bool, MutableContent, false);

    R_READONLY(ui32, PackSize, 1000);
    R_READONLY(TDuration, PacksInterval, TDuration::Seconds(30));

    R_READONLY(TVector<TString>, AppNames);

private:
    static TFactory::TRegistrator<TPushNotificationsConfig> Registrator;

    virtual void DoInit(const TYandexConfig::Section* section) override;
    virtual void DoToString(IOutputStream& os) const override;

public:
    virtual NDrive::INotifier::TPtr Construct() const override;

    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    virtual NJson::TJsonValue SerializeToJson() const override;
};

class TPushNotifier: public NDrive::INotifier {
protected:
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
    NSimpleMeta::TConfig ReaskConfig;
    const TPushNotificationsConfig Config;

public:
    TPushNotifier(const TPushNotificationsConfig& config);
    virtual ~TPushNotifier();

    virtual void DoStart(const IServerBase* /*server*/) override;
    virtual void DoStop() override;

    virtual void SubscribeUser(const TString& appName, const TString& platform, const TString& passportUid, const TString& uuid, const TString& pushToken, THolder<NNeh::THttpAsyncReport::ICallback>&& callback) const;

private:
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;
    NUtil::THttpReply NotifyImpl(const TMessage& message,
                                 TRecipients::const_iterator recipientsBegin,
                                 TRecipients::const_iterator recipientsEnd) const;
};
