#pragma once

#include <drive/backend/abstract/notifier.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <rtline/library/metasearch/simple/config.h>

namespace NNeh {
    class THttpClient;
}

class TAsyncDelivery;

namespace NTvmAuth {
    class TTvmClient;
}

class TSMSNotificationsConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;

public:
    R_READONLY(TVector<TString>, DefaultRecipients);
    R_READONLY(TString, Host);
    R_READONLY(ui16, Port, 443);
    R_READONLY(bool, IsHttps, true);
    R_READONLY(TString, Sender);
    R_READONLY(TString, Route);
    R_READONLY(ui32, SelfTvmId, 0);
    R_READONLY(ui32, DestinationTvmId, 0);
    R_READONLY(ui32, MaxInFlight, 100);
    R_READONLY(TDuration, ResponseTimeout, TDuration::Seconds(10));

public:
    void DoInit(const TYandexConfig::Section* section) override;
    void DoToString(IOutputStream& os) const override;
    NDrive::INotifier::TPtr Construct() const override;

    bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    static TFactory::TRegistrator<TSMSNotificationsConfig> Registrator;
};

// TSMSNotifier uses yasms (sms.passport.yandex.ru) to send messages.
class TSMSNotifier: public NDrive::INotifier {
private:
    const TSMSNotificationsConfig Config;
    TAtomicSharedPtr<TAsyncDelivery> AD;
    THolder<NNeh::THttpClient> Agent;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;

public:
    TSMSNotifier(const TSMSNotificationsConfig& config);
    ~TSMSNotifier() override;

    void DoStart(const IServerBase* /*server*/) override;
    void DoStop() override;

    TMaybe<ui32> GetSelfTvmId() const override;
    void SetTvmClient(TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient) override;

private:
    TResult::TPtr DoNotify(const TMessage& message,
                           const TContext& context) const override;
};

