#pragma once

#include <drive/backend/abstract/notifier.h>
#include <drive/library/cpp/aws/init.h>

#include <aws/core/auth/AWSCredentials.h>
#include <aws/core/client/ClientConfiguration.h>
#include <aws/sns/SNSClient.h>

class TSnsNotifierConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;

public:
    TSnsNotifierConfig();

    NDrive::INotifier::TPtr Construct() const override;

    void DoInit(const TYandexConfig::Section* section) override;
    void DoToString(IOutputStream& os) const override;

    bool DeserializeFromJson(const NJson::TJsonValue& /*info*/, TMessagesCollector& errors) override {
        errors.AddMessage("SNSNotifierConfig::DeserializeFromJson", "not supported");
        return false;
    }

public:
    R_FIELD(TString, Region);
    R_FIELD(TString, AccessKeyId);
    R_FIELD(TString, AccessSecretKey);

private:
    TAwsGuard AwsGuard;

private:
    static TFactory::TRegistrator<TSnsNotifierConfig> Registrator;
};

class TSnsNotifier: public NDrive::INotifier {
private:
    using TBase = NDrive::INotifier;

public:
    TSnsNotifier(const TSnsNotifierConfig& config);

protected:
    TResult::TPtr DoNotify(const TMessage& message, const TContext& context) const override;

    void DoStart(const IServerBase* server) override;
    void DoStop() override;

private:
    Aws::Auth::AWSCredentials Credentials;
    Aws::Client::ClientConfiguration ClientConfiguration;

    std::unique_ptr<Aws::SNS::SNSClient> Client;
};
