#pragma once

#include <drive/backend/abstract/notifier.h>
#include <drive/backend/support_center/support_ai/entities.h>


class TSupportAINotifierResult: public NDrive::TNotifierResult {
    using TBase = NDrive::TNotifierResult;

public:
    using TBase::TBase;

    NJson::TJsonValue SerializeToJson() const override;

    R_FIELD(TVector<TSupportAICall>, CallData);
};

class TSupportAINotificationsConfig: public NDrive::INotifierConfig {
private:
    using TBase = NDrive::INotifierConfig;
    using TFeatures = TMap<TString, TString>;
    R_READONLY(ui32, MaxInFlight, 10);
    R_READONLY(TFeatures, OverrideFeatures);
    R_READONLY(TString, OverridePhone);

public:
    void DoInit(const TYandexConfig::Section* section) override;
    void DoToString(IOutputStream& os) const override;
    NDrive::INotifier::TPtr Construct() const override;

    bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    NJson::TJsonValue SerializeToJson() const override;
    NDrive::TScheme GetScheme(const IServerBase& server) const override;

private:
    static TFactory::TRegistrator<TSupportAINotificationsConfig> Registrator;
};

class TSupportAINotifier: public NDrive::INotifier {
public:
    TSupportAINotifier(const TSupportAINotificationsConfig& config);
    ~TSupportAINotifier() override;
    void DoStart(const IServerBase* /*server*/) override;
    void DoStop() override;

private:
    TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;

private:
    const TSupportAINotificationsConfig Config;
};
