#pragma once

#include <drive/backend/abstract/notifier.h>

#include <drive/library/cpp/taxi/ucommunications/client.h>

#include <library/cpp/yconf/conf.h>

class TTaxiCommunicationsNotifierConfig
    : public NDrive::INotifierConfig
    , public NDrive::TTaxiCommunicationsClient::TOptions
{
private:
    using TBase = NDrive::INotifierConfig;

public:
    ui32 SelfClientId = 0;

public:
    virtual NDrive::INotifier::TPtr Construct() const override;

    virtual NDrive::TScheme GetScheme(const IServerBase& server) const override;

    virtual bool DeserializeFromJson(const NJson::TJsonValue& info, TMessagesCollector& errors) override;
    virtual NJson::TJsonValue SerializeToJson() const override;

private:
    virtual void DoInit(const TYandexConfig::Section* section) override;
    virtual void DoToString(IOutputStream& os) const override;

private:
    static TFactory::TRegistrator<TTaxiCommunicationsNotifierConfig> Registrator;
};

class TTaxiCommunicationsNotifier: public NDrive::INotifier {
public:
    TTaxiCommunicationsNotifier(const TTaxiCommunicationsNotifierConfig& config);
    ~TTaxiCommunicationsNotifier();

protected:
    virtual TResult::TPtr DoNotify(const TMessage& message, const TContext& context = Default<TContext>()) const override;

    virtual void DoStart(const IServerBase* server) override;
    virtual void DoStop() override;

private:
    const TTaxiCommunicationsNotifierConfig Config;

    THolder<NDrive::TTaxiCommunicationsClient> Client;
};
