#pragma once

#include <drive/backend/abstract/notifier.h>

template <class TNotifier, class TNotifierConfig>
class TNotifierHolder {
public:
    TNotifierHolder(const TNotifierConfig& config)
        : TNotifierHolder(config, config.GetPort())
    {
    }
    TNotifierHolder(const TNotifierConfig& config, ui16 port)
        : Notifier(config)
        , Port(port)
    {
        Notifier.Start(nullptr);
    }
    ~TNotifierHolder() {
        Notifier.Stop();
    }
    ui16 GetPort() {
        return Port;
    }
    NDrive::INotifier::TResult::TPtr SendTestMessage(
            const NDrive::INotifier::TMessage& message,
            const NDrive::INotifier::TRecipients& recipients) {
        return SendTestMessage(message, NDrive::INotifier::TContext().SetRecipients(recipients));
    }
    NDrive::INotifier::TResult::TPtr SendTestMessage(
            const NDrive::INotifier::TMessage& message,
            const NDrive::INotifier::TContext& context) {
        return Notifier.Notify(message, context);
    }
private:
    TNotifier Notifier;
    ui16 Port;
};
