#include "helpers.h"

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>
#include <drive/backend/notifications/mail/mail.h>
#include <rtline/library/async_proxy/ut/helper/fixed_response_server.h>
#include <util/system/env.h>

namespace {
    TMailNotificationsConfig GetMailNotificationsConfig() {
        TStringStream ss;
        auto serverPort = Singleton<TPortManager>()->GetPort();
        ss << "NotificationType: mail" << Endl
           << "Host: localhost" << Endl
           << "Port: " << ToString(serverPort) << Endl
           << "IsHttps: false" << Endl
           << "Account: test.account" << Endl
           << "Token: test_token" << Endl;
        return NDrive::INotifierConfig::BuildFromString<TMailNotificationsConfig>(ss.Str());
    }
}

Y_UNIT_TEST_SUITE(MailNotifications) {
    Y_UNIT_TEST(Smoke) {
        NJson::TJsonValue args = NJson::TJsonValue(NJson::JSON_MAP);
        args["name"] = "Robot Carsharing";
        args["template_text"] = "MailNotifications unittest";
        NDrive::INotifier::TMessage message("unittest.message",
                                            args.GetStringRobust());

        TNotifierHolder<TMailNotifier, TMailNotificationsConfig> notifier(
                GetMailNotificationsConfig());
        auto pushServerMock = TFixedResponseServer::BuildAndRun(notifier.GetPort(), {{200, ""}});
        auto resp = notifier.SendTestMessage(
                message,  {TUserContacts().SetEmail("robot-carsharing@yandex-team.ru")});
        UNIT_ASSERT(resp);
        UNIT_ASSERT(!resp->HasErrors());
    }
    Y_UNIT_TEST(Multiple) {
        NJson::TJsonValue args = NJson::TJsonValue(NJson::JSON_MAP);
        args["name"] = "Robot Carsharing";
        args["template_text"] = "MailNotifications unittest";
        NDrive::INotifier::TMessage message("unittest.message",
                                            args.GetStringRobust());

        TNotifierHolder<TMailNotifier, TMailNotificationsConfig> notifier(
                GetMailNotificationsConfig());
        auto pushServerMock =
                TFixedResponseServer::BuildAndRun(notifier.GetPort(), {{200, ""}, {400, ""}});
        auto resp = notifier.SendTestMessage(
                message, {
                    TUserContacts().SetEmail("robot-carsharing@yandex-team.ru"),
                    TUserContacts().SetEmail("wrong_email"),
                });
        UNIT_ASSERT(resp);
        UNIT_ASSERT(resp->HasErrors());
        UNIT_ASSERT_C(pushServerMock->GetCallsCount() == 2,
                      TStringBuilder() << "Actual calls count:" << pushServerMock->GetCallsCount());
    }
}
