#include "helpers.h"

#include <drive/backend/notifications/sms/sms.h>
#include <rtline/library/async_proxy/ut/helper/fixed_response_server.h>
#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/system/env.h>

namespace {
    const TString YASMS_OK_RESPONSE =
            TStringBuilder()
            << "<?xml version=\"1.0\" encoding=\"windows-1251\"?>" << Endl
            << "<doc>" << Endl
            << " <message-sent id=\"127000000003456\" />" << Endl
            << "</doc>";

    const TString YASMS_ERROR_RESPONSE =
            TStringBuilder()
             << "<?xml version=\"1.0\" encoding=\"windows-1251\"?>" << Endl
             << "<doc>" << Endl
             << "<error>User does not have an active phone to recieve messages</error>" << Endl
             << "<errorcode>NOCURRENT</errorcode>" << Endl
             << "</doc>";

    TUserContacts CreateUserContact(const TString& phone, const TString& uid) {
        TUserContacts result;
        result.SetPhone(phone);
        result.SetUid(uid);
        return result;
    }

    TSMSNotificationsConfig GetSMSNotificationsConfig() {
        TStringStream ss;
        auto serverPort = Singleton<TPortManager>()->GetPort();
        ss << "NotificationType: sms" << Endl
           << "Host: localhost" << Endl
           << "Port: " << ToString(serverPort) << Endl
           << "IsHttps: false" << Endl
           << "Sender: Yandex.Drive" << Endl
           << "Route: drive" << Endl;
        return NDrive::INotifierConfig::BuildFromString<TSMSNotificationsConfig>(ss.Str());
    }
}

Y_UNIT_TEST_SUITE(SMSNotifications) {
    Y_UNIT_TEST(SmokeOk) {
        TNotifierHolder<TSMSNotifier, TSMSNotificationsConfig> notifier(
                GetSMSNotificationsConfig());
        auto pushServerMock = TFixedResponseServer::BuildAndRun(
                notifier.GetPort(), {{200, YASMS_OK_RESPONSE}});
        auto resp = notifier.SendTestMessage(
                NDrive::INotifier::TMessage("Test"),
                {CreateUserContact("+71234567890", "test_uid")});
        UNIT_ASSERT(resp);
        UNIT_ASSERT(!resp->HasErrors());
    }

    Y_UNIT_TEST(SmokeError) {
        TNotifierHolder<TSMSNotifier, TSMSNotificationsConfig> notifier(
                GetSMSNotificationsConfig());
        auto pushServerMock = TFixedResponseServer::BuildAndRun(
                notifier.GetPort(), {{200, YASMS_ERROR_RESPONSE}});
        auto resp = notifier.SendTestMessage(
                NDrive::INotifier::TMessage("Test"),
                {CreateUserContact("+71234567890", "test_uid")});
        UNIT_ASSERT(resp);
        UNIT_ASSERT(resp->HasErrors());
    }

    Y_UNIT_TEST(MultipleResponse) {
        TNotifierHolder<TSMSNotifier, TSMSNotificationsConfig> notifier(
                GetSMSNotificationsConfig());
        auto pushServerMock = TFixedResponseServer::BuildAndRun(
                notifier.GetPort(),
                {{200, YASMS_ERROR_RESPONSE}, {200, YASMS_OK_RESPONSE}, {500, ""}});
        auto resp = notifier.SendTestMessage(
                NDrive::INotifier::TMessage("Test"),
                {CreateUserContact("+71234567890", "test1_uid"),
                 CreateUserContact("+71234567891", "test2_uid"),
                 CreateUserContact("+71234567892", "test3_uid")});
        UNIT_ASSERT(resp);
        UNIT_ASSERT(resp->HasErrors());
        UNIT_ASSERT_EQUAL(pushServerMock->GetCallsCount(), 3);
    }
}

