#pragma once

#include <drive/backend/abstract/notifier.h>

template <class TNotifier, class TNotifierConfig>
class TNotifierHolder {
    R_READONLY(TNotifier, Notifier);
public:
    TNotifierHolder(const TNotifierConfig& config)
    : Notifier(config)
    {
        Notifier.Start(nullptr);
    }

    ~TNotifierHolder() {
        Notifier.Stop();
    }

    NDrive::INotifier::TResult::TPtr SendTestMessage(
            const NDrive::INotifier::TMessage& message,
            const NDrive::INotifier::TRecipients& recipients) {
        return SendTestMessage(message, NDrive::INotifier::TContext().SetRecipients(recipients));
    }

    NDrive::INotifier::TResult::TPtr SendTestMessage(
            const NDrive::INotifier::TMessage& message,
            const NDrive::INotifier::TContext& context) {
        return Notifier.Notify(message, context);
    }
};
