#include <drive/backend/notifications/mail/mail.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/system/env.h>

#include <drive/backend/notifications/ut_large/helpers.h>

namespace {
    TMailNotificationsConfig GetMailNotoficationsConfig() {
        TStringStream ss;
        ss << "NotificationType: mail" << Endl
           << "Host: test.sender.yandex-team.ru" << Endl
           << "Account: yandex.carshare" << Endl
           << "TokenPath: " << GetEnv("TESTING_SENDER_TOKEN_PATH") << Endl;
        return NDrive::INotifierConfig::BuildFromString<TMailNotificationsConfig>(ss.Str());
    }
}

Y_UNIT_TEST_SUITE(MailNotifications) {
    Y_UNIT_TEST(Smoke) {
        NJson::TJsonValue args = NJson::TJsonValue(NJson::JSON_MAP);
        args["name"] = "Robot Carsharing";
        args["template_text"] = "MailNotifications unittest";
        NDrive::INotifier::TMessage message("unittest.message",
                                            args.GetStringRobust());

        NJson::TJsonValue attachments = NJson::JSON_ARRAY;
        NJson::TJsonValue& attach = attachments.AppendValue(NJson::JSON_MAP);
        attach["filename"] = "a.txt";
        attach["mime_type"] = "text/plain";
        attach["data"] = "dGVzdCBmaWxl";
        message.SetAdditionalInfo(attachments);

        TNotifierHolder<TMailNotifier, TMailNotificationsConfig> notifier(GetMailNotoficationsConfig());
        auto resp = notifier.SendTestMessage(message,  {TUserContacts().SetEmail("robot-carsharing@yandex-team.ru")});
        UNIT_ASSERT(resp);
        UNIT_ASSERT(!resp->HasErrors());
    }

    Y_UNIT_TEST(MultipleRecipients) {
        NJson::TJsonValue args = NJson::TJsonValue(NJson::JSON_MAP);
        args["name"] = "Robot Carsharing";
        args["template_text"] = "MailNotifications unittest";
        NDrive::INotifier::TMessage message("unittest.message", args.GetStringRobust());

        TNotifierHolder<TMailNotifier, TMailNotificationsConfig> notifier(GetMailNotoficationsConfig());
        auto resp = notifier.SendTestMessage(
                message, {
                    TUserContacts().SetEmail("robot-carsharing@yandex-team.ru"),
                    TUserContacts().SetEmail("wrong_email"),
                });
        UNIT_ASSERT(resp);
        UNIT_ASSERT(resp->HasErrors());
    }
}
