#include "yt_notifier.h"

#include <drive/library/cpp/yt/common/init.h>
#include <drive/library/cpp/yt/node/cast.h>

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/io-inl.h>


void TYtNotifier::DoStart(const IServerBase* /*server*/) {
}

NYT::TNode MessageToNode(const NDrive::INotifier::TMessage& message) {
    auto node = message.GetAdditionalInfo().IsDefined() ? NYT::ToNode(message.GetAdditionalInfo()) : NYT::TNode::CreateEntity();
    node["body"] = message.GetBody();
    node["title"] = message.GetTitle();
    node["header"] = message.GetHeader();
    node["name"] = message.GetName();
    return node;
}

NYT::TRichYPath TYtNotifier::ConstructRichPath() const {
    TString tableName = Config.GetTableName().empty() ? Now().ToStringLocalUpToSeconds() : Config.GetTableName();
    NYT::TYPath path = Config.GetTablePath() + '/' + tableName;
    return NYT::TRichYPath(path).Append(Config.GetAppend());
}

NDrive::INotifier::TResults TYtNotifier::MultiLinesNotify(const TString& commonHeader, const NDrive::INotifier::TMessages& reportMessages, const NDrive::INotifier::TContext& context) const {
    Y_UNUSED(commonHeader);
    Y_UNUSED(context);
    TResults results;
    try {
        NYT::IClientPtr client = NYT::CreateClient(Config.GetCluster());
        NYT::ITransactionPtr transaction = client->StartTransaction();
        auto writer = transaction->CreateTableWriter<NYT::TNode>(ConstructRichPath());
        for (auto&& message : reportMessages) {
            auto node = MessageToNode(*message);
            writer->AddRow(node);
        }
        writer->Finish();
        transaction->Commit();
    } catch (const std::exception& e) {
        results.push_back(MakeAtomicShared<TResult>("YT export failed", FormatExc(e)));
    }

    return results;
}

NDrive::INotifier::TResult::TPtr TYtNotifier::DoNotify(const NDrive::INotifier::TMessage& message, const NDrive::INotifier::TContext& context) const {
    Y_UNUSED(context);
    try {
        NYT::IClientPtr client = NYT::CreateClient(Config.GetCluster());
        NYT::ITransactionPtr transaction = client->StartTransaction();
        auto writer = transaction->CreateTableWriter<NYT::TNode>(ConstructRichPath());
        auto node = MessageToNode(message);
        writer->AddRow(node);
        writer->Finish();
        transaction->Commit();
    } catch (const std::exception& e) {
        return MakeAtomicShared<TResult>("YT export failed", FormatExc(e));
    }
    return nullptr;
}

void TYtNotifier::DoStop() {
}

TYtNotifierConfig::TFactory::TRegistrator<TYtNotifierConfig> TYtNotifierConfig::Registrator("yt");

NDrive::INotifier::TPtr TYtNotifierConfig::Construct() const {
    return MakeAtomicShared<TYtNotifier>(*this);
}
