#pragma once

#include "offer_price.h"

#include <drive/backend/offers/offers/abstract.h>

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/areas/location.h>
#include <drive/backend/common/host_filter.h>

#include <rtline/library/time_restriction/time_restriction.h>
#include <rtline/util/types/accessor.h>

enum class EOfferCorrectorResult {
    Success /* "success" */,
    Unimplemented /* "unimplemented" */,
    RejectOffer /* "reject_offer" */,
    BuildingProblems /* "building_problem" */,
    Problems /* "problems" */
};

class TOffersBuildingContext;
class TUserPermissions;

// TODO: ICommonOfferActionTraits -> IOfferActionGeoConditions
class TCommonOfferActionTraits {
public:
    R_READONLY(TSet<TString>, DeviceTagsInPoint);
    R_READONLY(ui32, DevicesInAreaCountFilter, 0);

protected:
    void FillScheme(NDrive::TScheme& result, const NDrive::IServer* server) const;
    bool FromJson(const NJson::TJsonValue& value);
    void ToJson(NJson::TJsonValue& value) const;

    TString CalcCacheId() const;
    EOfferCorrectorResult CheckGeoConditions(const TOffersBuildingContext& context, const TString& cacheId) const;
    EOfferCorrectorResult CheckGeoConditionsImpl(const TOffersBuildingContext& context) const;

public:
    EOfferCorrectorResult CheckVisibleForUserGeoConditions(const TOffersBuildingContext& context) const;
};

// TODO: ICommonOfferBuilderAction -> IOfferBuilderAction
class ICommonOfferBuilderAction
    : public TUserAction
    , public TCommonOfferActionTraits
{
private:
    using TBase = TUserAction;
    using TLocalizations = TMap<TString, TString>;

    R_READONLY(i32, ListPriority, 0);
    R_READONLY(bool, IsPublish, true);
    R_READONLY(bool, Hidden, false);
    R_READONLY(ui32, PaymentDiscretization, DefaultPaymentDiscretization);
    R_READONLY(TString, GroupName);
    R_READONLY(TMaybe<TOfferVisual>, Visual, {});
    R_READONLY(TLocalizations, Localizations);
    R_FIELD(TTimeRestrictionsPool<TTimeRestriction>, ActivityInterval);
    R_FIELD(TSet<TString>, ChargableAccounts);
    R_FIELD(TSet<TString>, TargetUserTags);
    R_FIELD(bool, Transferable, true);
    R_FIELD(TSet<TCiString>, SwitchOfferTagsList);
    R_FIELD(TSet<TString>, Origins);
    R_OPTIONAL(ui64, OrganizationId);

protected:
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;
    virtual EOfferCorrectorResult DoBuildOffers(const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const = 0;
    virtual EOfferCorrectorResult DoCheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const = 0;

public:
    EOfferCorrectorResult CheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const;
    TVector<IOfferReport::TPtr> BuildOffers(const TOffersBuildingContext& context, NDrive::TInfoEntitySession& session, bool useCorrectors = true) const;
    virtual EOfferCorrectorResult BuildOffers(const TUserPermissions& permissions, const TUserActions& correctors, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;
    virtual EOfferCorrectorResult BuildOffersClean(const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual NJson::TJsonValue GetPublicReport(ELocalization locale, const ILocalization& localization) const override;
    virtual bool CheckDeviceTagsPerformer(const TTaggedObject& taggedObject, const TUserPermissions& permissions, bool checkEmptyPerformer = true) const;
    static bool CheckDeviceTagsPerformerDefault(const TTaggedObject& taggedObject, const TUserPermissions& permissions, bool checkEmptyPerformer = true);
};

// TODO: IOfferBuilderAction -> IVehicleOfferBuilderAction
class IOfferBuilderAction : public ICommonOfferBuilderAction
{
private:
    using TBase = ICommonOfferBuilderAction;

    R_READONLY(bool, FuturesAvailable, true);
    R_FIELD(bool, AvailableForScanner, true);
    R_FIELD(TString, ProfitDescription);
    R_FIELD(TString, PromoDescription);
    R_FIELD(TString, PromoIcon);
    R_FIELD(TString, PromoDetailedDescription);

protected:
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

public:
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual NJson::TJsonValue GetPublicReport(ELocalization locale, const ILocalization& localization) const override;

    bool CheckVisibleBoons(const TOffersBuildingContext& context) const {
        return CheckVisibleForUserGeoConditions(context) == EOfferCorrectorResult::Success;
    }

    static TVector<TString> GetNames(const NDrive::IServer* server);
};

class IOfferCorrectorAction
    : public TUserAction
    , public TCommonOfferActionTraits
{
public:
    static constexpr ui32 DefaultPriority = 1000;

private:
    using TBase = TUserAction;

private:
    R_READONLY(ui32, Priority, DefaultPriority);
    R_FIELD(TSet<TString>, ChargableAccounts);
    R_FIELD(TTagsFilter, OfferTagsFilter);
    R_FIELD(THostFilter, HostFilter);
    R_FIELD(TSet<TString>, InsuranceDescriptions);
    R_FIELD(bool, ResetSurgeTypes, false);

protected:
    virtual EOfferCorrectorResult DoApplyForOffer(IOfferReport* offer, const TVector<TDBTag>& tags, const TOffersBuildingContext& context, const TString& userId,  const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const = 0;
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

public:
    using TUserAction::TUserAction;
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual EOfferCorrectorResult ApplyForOffer(IOfferReport* offer, const TVector<TDBTag>& tags, const TOffersBuildingContext& context, const TString& userId, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;
    static TVector<TString> GetNames(const NDrive::IServer* server);
};

namespace NDrive {

    // IDeliveryAreaFilter represents object that provides area tags filter for delivery area.
    //
    // This interface is used by areas handler.
    class IDeliveryAreaFilter {
    public:
        virtual ~IDeliveryAreaFilter() = default;

        virtual TMaybe<TBaseAreaTagsFilter> GetDeliveryAreaFilter() const = 0;

        bool CheckDeliveryLocation(const TGeoCoord& location, const IServer& server) const;
    };

    TString GetOfferAgreement(const TString& agreement, const TOffersBuildingContext& context, const TString& insuranceType);

    void LogCreatedOffers(const TVector<IOfferReport::TPtr>& offers);

}
