#pragma once

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/data/additional_service.h>
#include <drive/backend/offers/actions/abstract.h>
#include <drive/backend/offers/offers/additional_service.h>
#include <drive/backend/offers/context.h>

class TOffersBuildingContext;

namespace NDrive {

    class TDailySchedule : public ISchedule {
    public:
        TDuration BeginDelay;
        TDuration EndDelay;
        TDuration DayTime;
        // NowTime contains runtime-only Now() value.
        TMaybe<TInstant> NowTime;

        TDailySchedule() = default;
        TDailySchedule(TDuration beginDelay, TDuration endDelay, TDuration dayTime, TMaybe<TInstant> nowTime = {});

        bool Contains(TInstant time) const override;

        TInstant GetNext(TInstant time) const override;

        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& json);
    };

}

class TAdditionalServiceOfferReport: public IOfferReport {
private:
    using TBase = IOfferReport;

protected:
    virtual TFullPricesContext* GetFullPricesContext() override { return nullptr; }
    virtual void DoRecalcPrices(const NDrive::IServer* /*server*/) override {}

private:
    R_FIELD(NDrive::ISchedule::TPtr, AvailableSchedule);

public:
    using TBaseOffer = TAdditionalServiceOffer;
    using TBase::TBase;

    TAdditionalServiceOfferReport(const IOfferReport& source)
        : TBase(source)
    {
    }

    virtual void ApplyFlowCorrection(const TString& /*areaId*/, const TOffersBuildingContext& /*context*/, const NDrive::IServer* /*server*/) override {}
    virtual void ApplyInternalCorrection(const TString& /*areaId*/, const TOffersBuildingContext& /*context*/, const NDrive::IServer* /*server*/) override {}
    virtual TString PredictDestination(const TOffersBuildingContext& /*context*/, const NDrive::IServer* /*server*/, const TCommonDestinationDetector& /*otherDetector*/) const override { return ""; }
    virtual void RecalculateFeatures() override {}

    NJson::TJsonValue BuildJsonReport(ELocalization locale, NDriveSession::TReportTraits traits, const NDrive::IServer& server, const TUserPermissions& permissions) const override;
};

class TAdditionalServiceOfferBuilder
    : public ICommonOfferBuilderAction
    , public NDrive::IDeliveryAreaFilter
{
private:
    using TBase = ICommonOfferBuilderAction;

    R_FIELD(ui64, Price, 0);
    R_FIELD(TTagsFilter, CarTagsFilter);
    R_FIELD(TString, Title);
    R_FIELD(TString, Subtitle);
    R_FIELD(TString, OrderButtonText);
    R_FIELD(TString, Icon);
    R_FIELD(TString, ScheduledAtTitle);
    R_FIELD(TString, ScheduledAtSubtitle);
    R_FIELD(TString, DeliveryLocationTitle);
    R_FIELD(TString, SameLocationTitle);
    R_FIELD(TString, DetailsTitle);
    R_FIELD(TString, DetailsSubtitle);
    // DeliveryAreaTagsFilter contains filter for allowed delivery area tags.
    R_FIELD(TString, DeliveryAreaTagsFilter);
    // DailySchedule contains schedule for offers.
    R_FIELD(NDrive::TDailySchedule, DailySchedule);
    // DeviceTags contains tag names for device.
    R_FIELD(TVector<TString>, DeviceTags);
    R_FIELD(TVector<TString>, CancelStartUserTags);

protected:
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

public:
    using TPtr = TAtomicSharedPtr<TAdditionalServiceOfferBuilder>;
    using TBase::TBase;

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual EOfferCorrectorResult DoBuildOffers(const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const override;
    virtual EOfferCorrectorResult DoCheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const override;

    static TString GetTypeName() {
        return "additional_service_offer_builder";
    }

    virtual TString GetType() const override {
        return GetTypeName();
    }

    TMaybe<TBaseAreaTagsFilter> GetDeliveryAreaFilter() const override;

    NDrive::ISchedule::TPtr GetAvailableSchedule(IOffer::TPtr parentOffer) const;

private:
    static TFactory::TRegistrator<TAdditionalServiceOfferBuilder> Registrator;
};
