#pragma once

#include <drive/backend/offers/action.h>
#include <drive/backend/offers/context.h>


class TBINChecker : public IDynamicActionChecker {
public:
    TBINChecker(const TOffersBuildingContext* context = nullptr)
        : Context(context)
    {}

    virtual IDynamicActionChecker::ECheckResult CheckAction(const TString& userId, const TContext& context, const TUserAction& action, const NDrive::IServer& server) const;
    bool CheckBINs(const TString& userId, const TUserAction& action, const NDrive::IServer& server) const;
protected:
    const TOffersBuildingContext* Context = nullptr;

    static TFactory::TRegistrator<TBINChecker> Registrator;
};
