#pragma once

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/offers/actions/abstract.h>
#include <drive/backend/offers/offers/dedicated_fleet.h>
#include <drive/backend/offers/context.h>
#include <drive/backend/data/dedicated_fleet.h>


class TDedicatedFleetUnitOfferBuilder : public ICommonOfferBuilderAction {
private:
    using TBase = ICommonOfferBuilderAction;

public:
    static constexpr TStringBuf DeltaCostNameId = "delta_cost";
    static constexpr TStringBuf OptionsNameId = "options";
    static constexpr TStringBuf ServiceTagsToPerformId = "service_tags_to_perform";
    static constexpr TStringBuf ServiceTagsToCheckId = "service_tags_to_check";

public:
    using TBase::TBase;
    using TPtr = TAtomicSharedPtr<TDedicatedFleetUnitOfferBuilder>;
    using TConstPtr = TAtomicSharedPtr<const TDedicatedFleetUnitOfferBuilder>;
    using TTimeIntervalValues = NDedicatedFleet::TTimeIntervalValuesAdapter;
    using TCommonFleetValues = NDedicatedFleet::TCommonFleetValuesAdapter;
    using TOption = TDedicatedFleetUnitOffer::TOption;
    using TOptions = TDedicatedFleetUnitOffer::TOptions;

public:
    static TString GetTypeName() {
        return "dedicated_fleet_unit_offer_builder";
    }

    TString GetType() const override {
        return GetTypeName();
    }

    void SetupOptions(const NJson::TJsonValue& optionsMap);

protected:
    EOfferCorrectorResult DoBuildOffers(
        const TUserPermissions& permissions,
        TVector<IOfferReport::TPtr>& offers,
        const TOffersBuildingContext& context,
        const NDrive::IServer* server,
        NDrive::TInfoEntitySession& session
    ) const override;
    EOfferCorrectorResult DoCheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const override;

    NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;
    NJson::TJsonValue SerializeSpecialsToJson() const override;

private:
    R_FIELD(double, DeltaCost, 0);
    R_FIELD(TOptions, Options);
    R_FIELD(TSet<TString>, ServiceTagsToPerform);
    R_FIELD(TSet<TString>, ServiceTagsToCheck);

public:
    DECLARE_FIELDS(
        Field(DeltaCost, DeltaCostNameId),
        Field(Options, OptionsNameId),
        Field(ServiceTagsToPerform, ServiceTagsToPerformId),
        Field(ServiceTagsToCheck, ServiceTagsToCheckId)
    )

private:
    static TFactory::TRegistrator<TDedicatedFleetUnitOfferBuilder> Registrator;
};

class TDedicatedFleetOfferBuilder : public IOfferBuilderAction {
private:
    using TBase = IOfferBuilderAction;

public:
    static constexpr TStringBuf CancellationOnPrepareCostId = "cancellation_on_prepare_cost";

public:
    using TBase::TBase;
    using TPtr = TAtomicSharedPtr<TDedicatedFleetOfferBuilder>;
    using TTimeIntervalValues = NDedicatedFleet::TTimeIntervalValuesAdapter;
    using TCommonFleetValues = NDedicatedFleet::TCommonFleetValuesAdapter;

public:
    static TString GetTypeName() {
        return "dedicated_fleet_offer_builder";
    }

    TString GetType() const override {
        return GetTypeName();
    }

protected:
    EOfferCorrectorResult DoBuildOffers( const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context,
        const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const override;
    EOfferCorrectorResult DoCheckOfferConditions( const TOffersBuildingContext& context, const TUserPermissions& permissions) const override;
    NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;
    NJson::TJsonValue SerializeSpecialsToJson() const override;

private:
    ui64 GetDefaultCount() const;
    TString GetDefaultTariffPlan() const;
    EOfferCorrectorResult SetTimeInfo(TDedicatedFleetOffer& offer, const TOffersBuildingContext& context, const NDrive::IServer& server) const;
    EOfferCorrectorResult SetFleetInfo(TDedicatedFleetOffer& offer, const TOffersBuildingContext& context, const NDrive::IServer& server) const;
    EOfferCorrectorResult BuildUnitOffer(ICommonOfferBuilderAction* action, TDedicatedFleetOffer::TUnitsOffersMap& reports,
        const TUserPermissions& permissions, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;
    EOfferCorrectorResult SetOptions(TUserAction* action, const NJson::TJsonValue& optionsMap) const;

private:
    R_FIELD(TString, UnitOfferBuilder);
    R_FIELD(TString, OfferHolderTag, TDedicatedFleetOfferHolderTag::Type());

    R_FIELD(TTimeIntervalValues, TimeIntervalData);
    R_FIELD(TCommonFleetValues, CommonFleetData);

    R_FIELD(bool, NeedDeferCommunication, false);
    R_FIELD(TDuration, DeferThreshold, TDuration::Days(60));

    R_FIELD(double, CancellationOnPrepareCost, 0);

    TTagsFilter AvailableTagsFilter;

public:
    DECLARE_FIELDS(
        Field(UnitOfferBuilder, "unit_offer_builder"),
        Field(OfferHolderTag, "offer_holder_tag"),
        Field(TimeIntervalData, "time_interval_data"),
        Field(CommonFleetData, "common_fleet_data"),
        Field(NeedDeferCommunication, "need_defer"),
        Field(DeferThreshold, "defer_threshold"),
        Field(CancellationOnPrepareCost, CancellationOnPrepareCostId)
    )

private:
    static TFactory::TRegistrator<TDedicatedFleetOfferBuilder> Registrator;
};
