#pragma once

#include <drive/backend/actions/abstract/action.h>
#include <drive/backend/offers/actions/abstract.h>
#include <drive/backend/offers/context.h>

class TOffersBuildingContext;

class TDistributingBlockAction
    : public TUserAction
    , public TCommonOfferActionTraits
{
private:
    using TBase = TUserAction;

public:
    using TPtr = TAtomicSharedPtr<TDistributingBlockAction>;

public:
    using TPlaceReportTraits = ui32;
    enum EPlaceReportTraits : TPlaceReportTraits {
        ReportInOffers = 1 << 0,
        ReportInMainScreen = 1 << 1,
    };

public:
    using TBase::TBase;

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override final;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override final;
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const;
    NJson::TJsonValue BuildJsonReport(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const;

protected:
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) = 0;
    virtual NJson::TJsonValue SerializeContextToJson() const = 0;

    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const = 0;
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const = 0;

private:
    virtual void BuildCommon(const NDrive::IServer& server, NJson::TJsonValue& result, const TVector<IOfferReport::TPtr>& offers) const;
    bool CheckShowsRestriction(const TOffersBuildingContext& context) const;
    // events can be fetched from context, but we pass them as arguments
    // to access the events from context only once to have consistent statistics about access count.
    bool CheckPeriodicalConstraints(const TVector<TDistributingBlockEvent::TPtr>& events, const TOffersBuildingContext& context) const;
    bool CheckAbsoluteConstraints(const TVector<TDistributingBlockEvent::TPtr>& events, const TOffersBuildingContext& context) const;
    bool IsCompatibleWith(EPlaceReportTraits placeTrait) const;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const = 0;

public:
    static const TString AllowDistributingBlockFlag;
    static const TString EnableShowsRestrictionSetting;
    static const TString AllowDistributingBlockInOffers;
    static const TString AllowDistributingBlockInMainScreen;

private:
    R_FIELD(TString, Description);
    R_FIELD(TString, Title);
    R_FIELD(TString, ImageUrl);
    R_FIELD(i64, Priority, 0);
    R_FIELD(TMaybe<ui32>, ShowTimes);
    R_FIELD(TMaybe<TInstant>, Deadline);
    TTimeRestriction TimeRestriction;
    R_FIELD(TPlaceReportTraits, PlaceReportTraits, 0);
    R_FIELD(bool, CloseAfterClickIfDeeplink, false);
    R_FIELD(bool, EnablePeriodicalShowsRestrictions, false);
};

class TInsuranceDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TInsuranceDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

protected:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;
    virtual void BuildCommon(const NDrive::IServer& server, NJson::TJsonValue& result, const TVector<IOfferReport::TPtr>& offers) const override;

private:
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    bool ActionInside = false;
    TString FallbackTitle;
    TString FallbackDescription;
};

class TPlusDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TPlusDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

    virtual void BuildCommon(const NDrive::IServer& server, NJson::TJsonValue& result, const TVector<IOfferReport::TPtr>& offers) const override;
    void BuildState(const TOffersBuildingContext& context) const;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    class TState {
    public:
        R_FIELD(bool, IsPlusUser, false);
        R_FIELD(ui64, PlusBalance, 0);
    };

private:
    R_FIELD(ui64, BalanceThreshold, 0);
    R_FIELD(TString, NonPlusUserTitle);
    R_FIELD(TString, PlusUserTitle);
    R_FIELD(TString, NonPlusUserDescription);
    R_FIELD(TString, PlusUserDescription);
    mutable TState State;
    bool ActionInside = false;
};

class TFlexiblePackDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TFlexiblePackDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;
};

class TExternalLinkDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TExternalLinkDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    R_FIELD(TString, ExternalLink);
};

class TIntroscreenDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TIntroscreenDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    R_FIELD(TString, Introscreen);
};

class TDeeplinkDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TDeeplinkDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& server, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    R_FIELD(TString, Deeplink);
};

class TMapObjectDistributingBlockAction : public TDistributingBlockAction {
private:
    using TBase = TDistributingBlockAction;

private:
    static TFactory::TRegistrator<TMapObjectDistributingBlockAction> Registrator;

public:
    static TString GetTypeName();

public:
    using TBase::TBase;

    virtual TString GetType() const override;
    virtual bool IsRelevant(const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& offers, EPlaceReportTraits placeTrait) const override;

private:
    virtual NDrive::TScheme DoGetContextScheme(const NDrive::IServer* server) const override;
    virtual bool DeserializeContextFromJson(const NJson::TJsonValue& jsonValue) override;
    virtual NJson::TJsonValue SerializeContextToJson() const override;
    virtual NJson::TJsonValue BuildContext(const NDrive::IServer& /* server */, const TOffersBuildingContext& context, const TVector<IOfferReport::TPtr>& /* offers */, EPlaceReportTraits /* placeTrait */) const override;
    virtual TPlaceReportTraits GetCompatibilityTraitsImpl() const override;

private:
    TGeoCoord CalculateObjectPosition(TGeoCoord coord, const TOffersBuildingContext& context) const;

private:
    R_FIELD(TString, WarningId);
};
