#pragma once

#include "pack.h"
#include "types.h"

class TFlexiblePackOffer: public TPackOffer {
private:
    using TBase = TPackOffer;

public:
    using TBase::TBase;

    static TString GetTypeNameStatic() {
        return "flexible_pack_offer";
    }
    virtual TString GetTypeName() const override {
        return GetTypeNameStatic();
    }

protected:
    virtual NJson::TJsonValue DoBuildJsonReport(const TReportOptions& options, const ICommonOfferBuilderAction* constructor, const NDrive::IServer& server) const override;

private:
    static TFactory::TRegistrator<TFlexiblePackOffer> Registrator;
};

class TFlexiblePackOfferBuilder: public TBasePackOfferConstructor {
private:
    using TBase = TBasePackOfferConstructor;

public:
    struct TMileageOption {
        ui64 Duration = 0;
        ui64 DefaultMileage = 0;
        TSet<ui64> Mileages;
        ui64 RecalculateDuration = 0;

        TMileageOption() = default;
        TMileageOption(ui64 duration, ui64 defaultMileage, TSet<ui64> mileages, ui64 recalculateDuration = 0)
            : Duration(duration)
            , DefaultMileage(defaultMileage)
            , Mileages(std::move(mileages))
            , RecalculateDuration(recalculateDuration)
        {
        }

        DECLARE_FIELDS(
            Field(Duration, "duration"),
            Field(DefaultMileage, "default_mileage"),
            Field(Mileages, "mileages"),
            Field(RecalculateDuration, "recalculate_duration")
        );
    };
    using TMileageOptions = TVector<TMileageOption>;

public:
    using TBase::TBase;

    static TString GetTypeName() {
        return "flexible_pack_offer_builder";
    }
    virtual TString GetType() const override {
        return GetTypeName();
    }

    TOfferVariable<ui64> CreateDurationTemplate() const;
    TOfferVariable<ui64> CreateMileageTemplate(TDuration duration, TMaybe<ui32> mileage = {}) const;

protected:
    virtual bool ConstructPackOffer(
        const TStandartOfferReport& standartOfferReport,
        const TOffersBuildingContext& context,
        const NDrive::IServer* server,
        TVector<IOfferReport::TPtr>& offers,
        NDrive::TInfoEntitySession& session
    ) const override;

    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;

private:
    static TOfferVariable<ui64> CreateDefaultDuration();
    static TOfferVariable<ui64> CreateDefaultMileage();

private:
    R_OPTIONAL(TMileageOptions, MileageOptions);
    R_OPTIONAL(TString, ZeroMileageDetailedDescription);
    R_FIELD(TOfferVariable<ui64>, DurationTemplate, CreateDefaultDuration());
    R_FIELD(TOfferVariable<ui64>, MileageTemplate, CreateDefaultMileage());

public:
    DECLARE_FIELDS(
        Field(DurationTemplate.OptionalDefaultValue(), "default_duration"),
        Field(MileageOptions, "mileage_options"),
        Field(ZeroMileageDetailedDescription, "zero_mileage_detailed_description")
    );

private:
    static TFactory::TRegistrator<TFlexiblePackOfferBuilder> Registrator;
};
