#include "helpers.h"

#include <drive/backend/offers/actions/standart.h>

TMaybe<bool> IsInFinishArea(const THistoryDeviceSnapshot& snapshot, const NDrive::IServer* server, const TVector<TGeoCoord>& finishArea, const TString& typeName) {
    auto location = snapshot.GetHistoryLocation();
    if (!location) {
        return {};
    }
    return IsInFinishArea(location->GetCoord(), server, finishArea, typeName);
}

TMaybe<bool> IsInFinishArea(const TGeoCoord& coordinate, const NDrive::IServer* server, const TVector<TGeoCoord>& finishArea, const TString& typeName) {
    auto ipc = GetFinishAreaPointContext(server, typeName);
    auto line = TPolyLine<TGeoCoord>(finishArea);
    return ipc.IsPointInternal(line, coordinate);
}


TInternalPointContext GetFinishAreaPointContext(const NDrive::IServer* server, const TString& typeName) {
    TInternalPointContext ipc;
    ipc.SetPolicy(TInternalPointContext::EInternalPolicySet::Potentially);
    if (server) {
        const auto& settings = server->GetSettings();
        ipc.SetPrecision(settings.GetValue<double>("offers." + typeName + ".finish_area_precision").GetOrElse(20));
    }
    return ipc;
}

THolder<TStandartOfferConstructor> GetStandartOfferConstructor(const NDrive::IServer* server, const TString& name) {
    THolder<TStandartOfferConstructor> result;
    TVector<TDBAction> actions = server->GetDriveAPI()->GetRolesManager()->GetActionsDB().GetCachedObjectsVector();
    for (auto&& action : actions) {
        const TStandartOfferConstructor* stOffer = action.GetAs<TStandartOfferConstructor>();
        if (stOffer && stOffer->GetName() == name) {
            result.Reset(new TStandartOfferConstructor(*stOffer));
            break;
        }
    }
    return result;
}
