#pragma once

#include <drive/backend/offers/actions/abstract.h>
#include <drive/backend/offers/actions/standart.h>
#include <drive/backend/offers/offers/standard_with_discount_area.h>

#include <util/generic/yexception.h>

class TStandardWithDiscountAreaOfferBuilder
    : public IOfferBuilderAction
{
private:
    using TBase = IOfferBuilderAction;

private:
    static TFactory::TRegistrator<TStandardWithDiscountAreaOfferBuilder> Registrator;

public:
    struct TAreaDescription {
        TVector<TGeoCoord> FinishArea;
        TString FinishAreaId;
        TGeoCoord Finish;
        TString FinishName;
        i32 Discount;

        TAreaDescription() = default;
        TAreaDescription(const TUserOfferContext::TDestinationDescription& destinationDescription);
    };

protected:
    bool DeserializeSpecialsFromJson(const NJson::TJsonValue& jsonValue) override;
    NJson::TJsonValue SerializeSpecialsToJson() const override;

    //TODO: this method will be deleted from inherited interface
    EOfferCorrectorResult DoCheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const override;
    //TODO: this method will be deleted from inherited interface
    EOfferCorrectorResult DoBuildOffers(const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const override {
        Y_UNUSED(permissions);
        Y_UNUSED(offers);
        Y_UNUSED(context);
        Y_UNUSED(server);
        Y_UNUSED(session);
        ythrow yexception() << "Unimplemented method!";
    }

public:
    TAtomicSharedPtr<TStandardWithDiscountAreaOfferReport> BuildStandardWithDiscountAreaOffer(const TStandartOffer& stOffer, const TStandardWithDiscountAreaOfferBuilder::TAreaDescription& description, const TOffersBuildingContext::TDestination& destination, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;
    EOfferCorrectorResult BuildStandardWithDiscountAreaOffers(const TStandartOffer& stOffer, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session, const TUserPermissions& permissions) const;
    EOfferCorrectorResult BuildOffers(const TUserPermissions& permissions, const TUserActions& correctors, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const override;

    static TString GetTypeStatic() {
        return "standard_with_discount_area_offer_builder";
    }

    static TString GetTypeName() {
        return GetTypeStatic();
    }

    TString GetType() const override {
        return GetTypeStatic();
    }

    NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

private:
    void FetchAreasFromKNearest(TVector<TAreaDescription>& areas, const TGeoCoord& coord, const NDrive::IServer& server, const TOffersBuildingContext& context) const;
    void FetchAreasFromSuggest(TVector<TAreaDescription>& areas, const TOffersBuildingContext& context) const;
    void FetchAreaFromUserPoint(TVector<TAreaDescription>& areas, const TUserOfferContext::TDestinationDescription& destinationDescription) const;
    void FetchAreaFromPolygonPoint(TVector<TAreaDescription>& areas, const TGeoCoord& coord, const NDrive::IServer& server) const;

    TVector<TAreaDescription> GetDestinationAreas(const TOffersBuildingContext& context, const NDrive::IServer& server) const;
    TMaybe<TAreaDescription> GetAreaDescriptionByTag(const TFullAreaInfo& areaInfo) const;
    TMaybe<TUserOfferContext::TDestinationDescription> GetDestination(const TOffersBuildingContext& context, const NDrive::IServer& server) const;

private:
    R_FIELD(TString, BaseOfferBuilder);
    R_FIELD(TString, DiscountModel);
    R_FIELD(TString, TagName);

    TTagsFilter TagsFilter;
    mutable TTagsFilter FinishAreaTagsFilter;
};
