#pragma once

#include "fix_point.h"
#include "pack.h"
#include "standart.h"

#include <rtline/util/algorithm/ptr.h>

class TTaxiFixPointOffer: public TFixPointOffer {
private:
    using TBase = TFixPointOffer;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_fixpoint_offer";
    }

    virtual TString GetTypeName() const override {
        return TypeName();
    }

    virtual TString GetReportedTypeName() const override {
        return TFixPointOffer::GetTypeName();
    }

private:
    static TFactory::TRegistrator<TTaxiFixPointOffer> Registrator;
};

class TTaxiFixPointOfferConstructor: public TPredestinedFixPointOfferConstructor {
private:
    using TBase = TPredestinedFixPointOfferConstructor;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_fixpoint_offer_builder";
    }

    virtual TString GetType() const override {
        return TypeName();
    }

protected:
    virtual THolder<TFixPointOfferReport> Extend(const TStandartOfferReport& standardOfferReport) const override;

    virtual double GetDistanceThreshold(const NDrive::IServer& /*server*/) const override {
        return 0;
    }
    virtual double GetHaversineThreshold(const NDrive::IServer& /*server*/) const override {
        return 0;
    }
    virtual bool IsInternalPointDisabled() const override {
        return false;
    }

private:
    static TFactory::TRegistrator<TTaxiFixPointOfferConstructor> Registrator;
};

class TTaxiPackOffer: public TPackOffer {
private:
    using TBase = TPackOffer;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_pack_offer";
    }

    virtual TString GetTypeName() const override {
        return TypeName();
    }

    virtual TString GetReportedTypeName() const override {
        return TPackOffer::GetTypeName();
    }

private:
    static TFactory::TRegistrator<TTaxiPackOffer> Registrator;
};

class TTaxiPackOfferConstructor: public TPackOfferConstructor {
private:
    using TBase = TPackOfferConstructor;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_pack_offer_builder";
    }

    virtual TString GetType() const override {
        return TypeName();
    }

protected:
    virtual THolder<TPackOfferReport> Extend(const TStandartOfferReport& standardOfferReport) const override;

private:
    static TFactory::TRegistrator<TTaxiPackOfferConstructor> Registrator;
};

class TTaxiDropoffOffer: public TStandartOffer {
private:
    using TBase = TStandartOffer;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_dropoff_offer";
    }

    virtual TString GetTypeName() const override {
        return TypeName();
    }

private:
    static TFactory::TRegistrator<TTaxiDropoffOffer> Registrator;
};

class TTaxiValidationOffer: public TStandartOffer {
private:
    using TBase = TStandartOffer;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_validation_offer";
    }

    virtual TString GetTypeName() const override {
        return TypeName();
    }

    virtual EDriveSessionResult DoCheckSession(const TUserPermissions& permissions, NDrive::TEntitySession& session, const NDrive::IServer* server, bool onPerform) const override;
    void SetTagName(const TString& value);

    bool DeserializeFromProto(const NDrive::NProto::TOffer& info) override;
    NDrive::NProto::TOffer SerializeToProto() const override;

private:
    TString TagName;

private:
    static TFactory::TRegistrator<TTaxiValidationOffer> Registrator;
};

class TTaxiMetaOfferReport: public TFixPointOfferReport {
private:
    using TBase = TFixPointOfferReport;

public:
    TTaxiMetaOfferReport(IOfferReport::TPtr fixPointReport, IOfferReport::TPtr secondary)
        : TBase(*Yensured(std::dynamic_pointer_cast<TFixPointOfferReport>(fixPointReport)))
        , Secondary(secondary)
    {
    }

    virtual NJson::TJsonValue BuildJsonReport(ELocalization locale, NDriveSession::TReportTraits traits, const NDrive::IServer& server, const TUserPermissions& permissions) const override;

private:
    IOfferReport::TPtr Secondary;
};

class TTaxiMetaOfferContructor: public IOfferBuilderAction {
private:
    using TBase = IOfferBuilderAction;

public:
    using TBase::TBase;

    static TString TypeName() {
        return "taxi_meta_offer_builder";
    }

    virtual TString GetType() const override {
        return TypeName();
    }

    void SetFixPointOfferName(const TString& value) {
        FixPointOfferName = value;
    }
    void SetPackOfferName(const TString& value) {
        PackOfferName = value;
    }
    void SetValidationTagName(const TString& value) {
        ValidationTagName = value;
    }

protected:
    virtual bool DeserializeSpecialsFromJson(const NJson::TJsonValue& value) override;
    virtual NJson::TJsonValue SerializeSpecialsToJson() const override;
    virtual EOfferCorrectorResult DoBuildOffers(const TUserPermissions& permissions, TVector<IOfferReport::TPtr>& offers, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const override;
    virtual EOfferCorrectorResult DoCheckOfferConditions(const TOffersBuildingContext& context, const TUserPermissions& permissions) const override;
    virtual NDrive::TScheme DoGetScheme(const NDrive::IServer* server) const override;

    IOfferReport::TPtr BuildOffer(const TString& name, const TUserPermissions& permissions, const TOffersBuildingContext& context, const NDrive::IServer* server, NDrive::TInfoEntitySession& session) const;

private:
    TString FixPointOfferName;
    TString PackOfferName;
    TString ValidationTagName;
    ui32 DropoffFreeTime = TDuration::Minutes(10).Seconds();
    ui32 DropoffOvertimePrice = 100;
    ui32 ValidationFreeTime = TDuration::Minutes(10).Seconds();
    ui32 ValidationOvertimePrice = 100;

private:
    static TFactory::TRegistrator<TTaxiMetaOfferContructor> Registrator;
};
