#pragma once

#include <library/cpp/json/json_value.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/field.h>

#include <util/generic/set.h>
#include <util/generic/string.h>

enum class ELocalization;

namespace NDrive {
    class IServer;
}

template <class T>
struct TOfferVariable {
public:
    struct TNamedValue {
        T Value;
        TMaybe<i64> Cost;
        TString Link;
        TString LinkTitle;
        TString Name;
        TString Subtitle;
        TString Unit;

        inline bool operator<(const TNamedValue& other) const {
            return Value < other.Value;
        }

        DECLARE_FIELDS(
            Field(Value, "value"),
            Field(Cost, "cost"),
            Field(Link, "link"),
            Field(LinkTitle, "link_title"),
            Field(Name, "name"),
            Field(Subtitle, "subtitle"),
            Field(Unit, "unit")
        )
    };

public:
    R_OPTIONAL(T, Value);
    R_OPTIONAL(T, DefaultValue);
    R_OPTIONAL(T, MinimalValue);
    R_OPTIONAL(T, MaximalValue);
    R_OPTIONAL(TVector<TNamedValue>, NamedValues);
    R_OPTIONAL(TSet<T>, Values);
    R_OPTIONAL(i64, Cost);
    R_OPTIONAL(i64, PredictedCost);
    R_OPTIONAL(TString, Type);
    R_FIELD(TString, Id);
    R_FIELD(TString, Title);
    R_FIELD(TString, Subtitle);
    R_FIELD(TString, Unit);

public:
    NJson::TJsonValue GetReport(ELocalization locale, const NDrive::IServer& server) const;

    TString GetType() const {
        if (Type) {
            return *Type;
        } else {
            return GetDefaultType();
        }
    }

    DECLARE_FIELDS(
        Field(Value, "value"),
        Field(DefaultValue, "default_value"),
        Field(MinimalValue, "minimal_value"),
        Field(MaximalValue, "maximal_value"),
        Field(NamedValues, "named_values"),
        Field(Values, "values"),
        Field(Cost, "cost"),
        Field(PredictedCost, "predicted_cost"),
        Field(Type, "type"),
        Field(Id, "id"),
        Field(Title, "title"),
        Field(Subtitle, "subtitle"),
        Field(Unit, "unit")
    )

private:
    static TString GetDefaultType();
};
