#include <drive/backend/offers/actions/ut/library/helper.h>

#include <drive/backend/offers/actions/pack.h>
#include <drive/backend/offers/actions/dedicated_fleet.h>

#include <drive/backend/data/dedicated_fleet.h>
#include <drive/backend/data/device_tags.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>


static const ui64 DeltaDurationCost = 120;

Y_UNIT_TEST_SUITE(DedicatedFleetOfferSuite) {
    Y_UNIT_TEST(Simple) {
        auto offer = MakeAtomicShared<TDedicatedFleetOffer>();
        auto unitOffer = MakeAtomicShared<TDedicatedFleetUnitOffer>();
        unitOffer->SetDeltaDurationCost(DeltaDurationCost);
        auto unitReport = MakeAtomicShared<TDedicatedFleetUnitOfferReport>(unitOffer, nullptr);
        offer->SetBaseUnitOffer(unitReport);

        TDedicatedFleetSession session;
        {
            TTagHistoryEventConstructor accountEventBase;
            TTagHistoryEventConstructor fleetTagEventBase;
            TTagHistoryEventConstructor fleetTagEventBase2;
            accountEventBase.SetObjectId("account").SetTagId("1").SetHistoryUserId("user");
            fleetTagEventBase.SetObjectId("object").SetTagId("2").SetHistoryUserId("user");
            fleetTagEventBase2.SetObjectId("object").SetTagId("3").SetHistoryUserId("user");

            AddAccountEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, TDedicatedFleetOfferHolderTag>
                (session, accountEventBase, TDedicatedFleetOfferHolderTag::Type(), TInstant::Seconds(1000), EObjectHistoryAction::Add);

            {
                THolder<TSpecialFleetTag> tag(new TSpecialFleetTag(TSpecialFleetTag::Actual));
                tag->SetUnitOfferId("2");
                AddEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, false>(
                    session, fleetTagEventBase, std::move(tag), TInstant::Seconds(1100), EObjectHistoryAction::Add);
            }

            {
                THolder<TSpecialFleetTag> tag(new TSpecialFleetTag(TSpecialFleetTag::Actual));
                tag->SetUnitOfferId("2");
                AddEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, false>(
                    session, fleetTagEventBase, std::move(tag), TInstant::Seconds(1300), EObjectHistoryAction::Remove);
            }

            {
                THolder<TSpecialFleetTag> tag(new TSpecialFleetTag(TSpecialFleetTag::Actual));
                tag->SetUnitOfferId("2");
                AddEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, false>(
                    session, fleetTagEventBase2, std::move(tag), TInstant::Seconds(1400), EObjectHistoryAction::Add);
            }

            {
                THolder<TSpecialFleetTag> tag(new TSpecialFleetTag(TSpecialFleetTag::Actual));
                tag->SetUnitOfferId("2");
                AddEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, false>(
                    session, fleetTagEventBase2, std::move(tag), TInstant::Seconds(1450), EObjectHistoryAction::Remove);
            }

            AddAccountEvent<TDedicatedFleetSession, TDedicatedFleetSessionSelector, TDedicatedFleetOfferHolderTag>
                (session, accountEventBase, TDedicatedFleetOfferHolderTag::Type(), TInstant::Seconds(1500), EObjectHistoryAction::UpdateData);
        }

        {
            TTestFleetOfferCompilation compilation(offer);
            compilation.SetSince(TInstant::Seconds(1000)).SetUntil(TInstant::Seconds(2000));
            UNIT_ASSERT(session.FillCompilation(compilation));
            auto state = std::dynamic_pointer_cast<TDedicatedFleetOfferState>(compilation.GetOfferState());
            UNIT_ASSERT(state);
            UNIT_ASSERT_VALUES_EQUAL(state->GetOfferTagDurationRef().Seconds(), 500);
            UNIT_ASSERT_VALUES_EQUAL(state->GetSummaryDurationRef().Seconds(), 250);
            UNIT_ASSERT_VALUES_EQUAL(state->GetDurationPriceRef(), 250 * DeltaDurationCost / 60);
        }
    }
}
