#include "helper.h"

#include <drive/backend/data/device_tags.h>


TVector<TAtomicSharedPtr<TTagHistoryEventConstructor>> TCommonEvents::EventsStorage;
std::atomic<NDrive::TEventId> TCommonEvents::CurrentCounter = 0;

void CheckSum(TBillingSession& session, const ui32 sum) {
    TBillingSession::TBillingCompilation compilation;
    compilation.SetUntil(TInstant::Max());
    CHECK_WITH_LOG(session.FillCompilation(compilation));
    CHECK_WITH_LOG(compilation.GetReportSumPrice() <= sum) << compilation.GetReportSumPrice() << "/" << sum;
    CHECK_WITH_LOG(compilation.GetReportSumPrice() >= sum - 1) << compilation.GetReportSumPrice() << "/" << sum;
}
void CheckBillingSum(TBillingSession& session, const ui32 sum) {
    TBillingSession::TBillingCompilation compilation;
    compilation.SetUntil(TInstant::Max());
    CHECK_WITH_LOG(session.FillCompilation(compilation));
    CHECK_WITH_LOG(compilation.GetBillingSumPrice() <= sum) << compilation.GetBillingSumPrice() << "/" << sum;
    CHECK_WITH_LOG(compilation.GetBillingSumPrice() >= sum - 1) << compilation.GetBillingSumPrice() << "/" << sum;
}

TTagHistoryEventConstructor& TTagHistoryEventConstructor::BuildEvent(TTagHistoryEventConstructor& base) {
    TCommonEvents::EventsStorage.emplace_back(new TTagHistoryEventConstructor(base));
    return *TCommonEvents::EventsStorage.back();
}
