#include <drive/backend/offers/actions/ut/library/helper.h>

#include <drive/backend/offers/actions/long_term.h>

#include <drive/backend/data/chargable.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(LongTermOffer) {
    Y_UNIT_TEST(PackFinishingDuringServicing) {
        TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent> timeline;
        TVector<TCarTagHistoryEvent> events;
        TBillingSession session;
        {
            auto acceptanceAfterServicing = MakeHolder<TChargableTag>("old_state_acceptance");
            acceptanceAfterServicing->SetServicingInfo({
                TInstant::Seconds(1030),
                TInstant::Seconds(1040),
                42.0
            });
            TCarTagHistoryEventConstructor eventBase;
            eventBase.SetObjectId("object").SetTagId("1").SetHistoryUserId("user");
            AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1000), EObjectHistoryAction::SetTagPerformer);
            AddEvent(session, eventBase, "old_state_acceptance", TInstant::Seconds(1002), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, "old_state_riding", TInstant::Seconds(1004), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, "old_state_parking", TInstant::Seconds(1014), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, "servicing", TInstant::Seconds(1020), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, std::move(acceptanceAfterServicing), TInstant::Seconds(1100), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1110), EObjectHistoryAction::TagEvolve);
            AddEvent(session, eventBase, "old_state_reservation", TInstant::Seconds(1110), EObjectHistoryAction::DropTagPerformer);
        }

        auto offer = BuildOfferPtr<TLongTermOffer>(100, 100, 102400);
        offer->SetDuration(TDuration::Seconds(42));
        offer->SetWeeklyCost(10000);
        {
            TTestCompilation compilation(offer);
            compilation.SetSince(TInstant::Zero()).SetUntil(TInstant::Max());
            UNIT_ASSERT(session.FillCompilation(compilation));
            auto offerState = compilation.GetOfferState();
            UNIT_ASSERT(offerState);
            auto longTermOfferState = std::dynamic_pointer_cast<TLongTermOfferState>(offerState);
            UNIT_ASSERT(longTermOfferState);
            auto predictedOvertime = TDuration::Seconds(1110 - 1000) - offer->GetDuration();
            UNIT_ASSERT_VALUES_EQUAL(longTermOfferState->GetOvertime(), predictedOvertime);
            UNIT_ASSERT_VALUES_EQUAL(longTermOfferState->GetServicingDuration(), TDuration::Seconds(10));
            UNIT_ASSERT_VALUES_EQUAL(longTermOfferState->GetServicingOmittedPrice(), offer->GetPackPrice() * 10 / 42);
            UNIT_ASSERT_DOUBLES_EQUAL(longTermOfferState->GetServicingMileage(), 42.0, 0.001);
            UNIT_ASSERT_DOUBLES_EQUAL(longTermOfferState->GetOvertimePrice(), 100 * predictedOvertime.Seconds() / 60, 1);
        }
    }
}
