LIBRARY()

OWNER(g:drive-backend)

SRCS(
    GLOBAL checkers.cpp
    GLOBAL correctors.cpp
    GLOBAL dedicated_fleet.cpp
    GLOBAL distributing_block.cpp
    GLOBAL fix_point.cpp
    GLOBAL flexipack.cpp
    GLOBAL flows_control.cpp
    helpers.cpp
    GLOBAL long_term.cpp
    GLOBAL rental_offer.cpp
    GLOBAL offer_price.cpp
    GLOBAL pack.cpp
    GLOBAL standart.cpp
    GLOBAL standard_with_discount_area.cpp
    GLOBAL taxi.cpp
    GLOBAL additional_service.cpp
    abstract.cpp
    types.cpp
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(abstract.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(distributing_block.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(long_term.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(rental_offer.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(standart.h)

PEERDIR(
    drive/backend/abstract
    drive/backend/common
    drive/backend/data/rental
    drive/backend/drivematics/signals
    drive/backend/database
    drive/backend/database/drive
    drive/backend/device_snapshot
    drive/backend/distributing_block_storage
    drive/backend/models
    drive/backend/offers
    drive/backend/offers/offers
    drive/backend/offers/price
    drive/backend/parking_zones
    drive/backend/proto
    drive/backend/saas
    drive/backend/surge
    drive/backend/tags
    drive/library/cpp/saturn
    drive/library/cpp/scheme
    drive/library/cpp/taxi
    drive/library/cpp/threading
    drive/library/cpp/user_events_api
    rtline/api/graph/router
    rtline/library/geometry
    rtline/library/graph/geometry_graph/common
    rtline/library/json/proto
    rtline/util/algorithm
    library/cpp/html/escape
)

END()
