#include "factors_info.h"

#include <rtline/library/factors_info/factors_info_factory.h>

namespace NDrive {
    const TString OfferFactorsInfoName = "offers";

    const TString OfferFactorsInfoName2 = "offers-2";
    const TString OfferCatFactorsInfoName2 = "offers-categories-2";

    class TFactorsInfo: public TSimpleFactorsInfo<NDriveOfferFactors::TFactorInfo> {
    public:
        TFactorsInfo()
            : TSimpleFactorsInfo<NDriveOfferFactors::TFactorInfo>(NDriveOfferFactors::FI_FACTOR_COUNT, NDriveOfferFactors::GetFactorsInfo())
        {
            for (size_t i = 0; i < NDriveOfferFactors::FI_FACTOR_COUNT; ++i) {
                if (HasTagId(i, NDriveOfferFactors::TFactorInfo::TG_USER_EXT_DATA)) {
                    ExternalUserFactors.push_back(i);
                }
            }
        }

        const TVector<size_t>& GetExternalUserFactors() const {
            return ExternalUserFactors;
        }

        bool HasTagId(size_t index, int tag) const override {
            if (Y_UNLIKELY(index >= FactorCount))
                return false;
            return FactorInfo[index].TagsData.TagsIds.contains(tag);
        }

    private:
        TVector<size_t> ExternalUserFactors;
    };

    class TFactorsInfo2: public TSimpleFactorsInfo<NDriveOfferFactors2::TFactorInfo> {
    public:
        TFactorsInfo2()
            : TSimpleFactorsInfo<NDriveOfferFactors2::TFactorInfo>(NDriveOfferFactors2::FI_FACTOR_COUNT, NDriveOfferFactors2::GetFactorsInfo())
        {
            for (size_t i = 0; i < NDriveOfferFactors2::FI_FACTOR_COUNT; ++i) {
                if (HasTagId(i, NDriveOfferFactors2::TFactorInfo::TG_USER_EXT_DATA)) {
                    ExternalUserFactors.push_back(i);
                }
            }
        }

        const TVector<size_t>& GetExternalUserFactors() const {
            return ExternalUserFactors;
        }

        bool HasTagId(size_t index, int tag) const override {
            if (Y_UNLIKELY(index >= FactorCount))
                return false;
            return FactorInfo[index].TagsData.TagsIds.contains(tag);
        }

    private:
        TVector<size_t> ExternalUserFactors;
    };

    class TCatFactorsInfo2 : public TSimpleFactorsInfo<NDriveOfferCatFactors2::TFactorInfo> {
    public:
        TCatFactorsInfo2()
            : TSimpleFactorsInfo<NDriveOfferCatFactors2::TFactorInfo>(NDriveOfferCatFactors2::FI_FACTOR_COUNT, NDriveOfferCatFactors2::GetFactorsInfo())
        {
            for (size_t i = 0; i < NDriveOfferCatFactors2::FI_FACTOR_COUNT; ++i) {
                if (HasTagId(i, NDriveOfferCatFactors2::TFactorInfo::TG_USER_EXT_DATA)) {
                    ExternalUserFactors.push_back(i);
                }
            }
        }

        const TVector<size_t>& GetExternalUserFactors() const {
            return ExternalUserFactors;
        }

        bool HasTagId(size_t index, int tag) const override {
            if (Y_UNLIKELY(index >= FactorCount))
                return false;
            return FactorInfo[index].TagsData.TagsIds.contains(tag);
        }

    private:
        TVector<size_t> ExternalUserFactors;
    };

    class TFactorsInfoGetter: public IFactorsInfoGetter {
    protected:
        const IFactorsInfo* Get() const override {
            return GetOfferFactorsInfo();
        }
    };

    const TString& GetOfferFactorsInfoName() {
        return OfferFactorsInfoName;
    }

    const IFactorsInfo* GetOfferFactorsInfo() {
        return Singleton<TFactorsInfo>();
    }

    const TVector<size_t>& GetExternalUserOfferFactors() {
        return Singleton<TFactorsInfo>()->GetExternalUserFactors();
    }

    class TFactorsInfoGetter2: public IFactorsInfoGetter {
    protected:
        const IFactorsInfo* Get() const override {
            return GetOfferFactorsInfo2();
        }
    };

    const TString& GetOfferFactorsInfoName2() {
        return OfferFactorsInfoName2;
    }

    const TString& GetCatOfferFactorsInfoName2() {
        return OfferCatFactorsInfoName2;
    }

    const IFactorsInfo* GetOfferFactorsInfo2() {
        return Singleton<TFactorsInfo2>();
    }

    const IFactorsInfo* GetCatOfferFactorsInfo2() {
        return Singleton<TCatFactorsInfo2>();
    }

    const TVector<size_t>& GetExternalUserOfferFactors2() {
        return Singleton<TFactorsInfo2>()->GetExternalUserFactors();
    }

    const TVector<size_t>& GetExternalUserCatOfferFactors2() {
        return Singleton<TCatFactorsInfo2>()->GetExternalUserFactors();
    }
}

TFactorsInfoFactory::TRegistrator<NDrive::TFactorsInfoGetter> OfferFactorsRegistrator(NDrive::OfferFactorsInfoName);
TFactorsInfoFactory::TRegistrator<NDrive::TFactorsInfoGetter2> OfferFactorsRegistrator2(NDrive::OfferFactorsInfoName2);
