#pragma once

#include "abstract.h"

class TBillingSession;

namespace NDrive::NProto {
    class TAdditionalServiceOffer;
}

class TAdditionalServiceOfferState: public IOfferState {
private:
    R_OPTIONAL(TString, Stage);

    R_FIELD(TString, DeliveryLocationName);
    R_FIELD(bool, SamePlace, false);
    R_OPTIONAL(TInstant, ScheduledAt);

    R_FIELD(TString, TitleKey);
    R_FIELD(TString, SubtitleKey);
    R_FIELD(TString, ButtonKey);
    R_FIELD(TString, ScheduledAtTitleKey);
    R_FIELD(TString, ScheduledAtSubtitleKey);
    R_FIELD(TString, DeliveryLocationTitleKey);
    R_FIELD(TString, SameLocationTitleKey);
    R_FIELD(TString, DetailsTitleKey);
    R_FIELD(TString, DetailsSubtitleKey);
    R_FIELD(NDrive::ISchedule::TPtr, AvailableSchedule);
    R_FIELD(bool, AvailableDeliveryLocation, false);

public:
    NJson::TJsonValue GetReport(ELocalization locale, const NDrive::IServer& server) const override;
    TString FormDescriptionElement(const TString& value, const TString& currency, ELocalization locale, const ILocalization& localization) const override;

};

class TAdditionalServiceOffer: public ICommonOffer {
public:
    using TAvailableTime = TVector<std::pair<TInstant, TInstant>>;

private:
    using TBase = ICommonOffer;

    R_FIELD(i64, Price, 0);
    R_FIELD(TInstant, ScheduledAt);
    R_OPTIONAL(TGeoCoord, DeliveryLocation);
    R_FIELD(TString, DeliveryLocationName);
    R_FIELD(bool, SameLocation, true);

    R_FIELD(TString, SessionId);

    // Build-time variables
    R_OPTIONAL(TVector<TGeoCoord>, DeliveryArea);

public:
    static TString GetTypeNameStatic() {
        return "additional_service_offer";
    }

    virtual TString GetTypeName() const override {
        return GetTypeNameStatic();
    }

public:
    bool DeserializeFromProto(const NDrive::NProto::TOffer& info) override;
    NDrive::NProto::TOffer SerializeToProto() const override;

    TOfferStatePtr Calculate(const TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& events, const TInstant& until) const;

    // GetBillingSession returns parent billing session.
    TAtomicSharedPtr<TBillingSession> GetBillingSession(const NDrive::IServer& server) const;

    TOptionalDBTags GetSessionDeviceTags(NDrive::TEntitySession& tx, TAtomicSharedPtr<TBillingSession> session, const NDrive::IServer& server) const;

protected:
    virtual NJson::TJsonValue DoBuildJsonReport(const TReportOptions& options, const ICommonOfferBuilderAction* constructor, const NDrive::IServer& server) const override;
    virtual TString DoFormDescriptionElement(const TString& value, ELocalization locale, const ILocalization* localization) const override;

private:
    static TFactory::TRegistrator<TAdditionalServiceOffer> Registrator;
};
