#include "dedicated_fleet_common.h"


using namespace NDedicatedFleet;

DECLARE_FIELDS_JSON_SERIALIZER(TTimeIntervalValues::TConstants);
DECLARE_FIELDS_JSON_SERIALIZER(TTimeIntervalValues::TStringConstants);
DECLARE_FIELDS_JSON_SERIALIZER(TCommonFleetValues::TConstants);
DECLARE_FIELDS_JSON_SERIALIZER(TCommonFleetValues::TStringConstants);
DECLARE_FIELDS_JSON_SERIALIZER(TOptionValues::TConstants);
DECLARE_FIELDS_JSON_SERIALIZER(TOptionValues::TStringConstants);


template <>
NJson::TJsonValue NJson::ToJson(const NDedicatedFleet::ECostCalculatePolicy& object) {
    return NJson::ToJson(NJson::Stringify(object));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDedicatedFleet::ECostCalculatePolicy& result) {
    return NJson::TryFromJson(value, NJson::Stringify(result));
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDedicatedFleet::TTimeIntervalValuesAdapter& result) {
    return result.DeserializeDataFromJson(value);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDedicatedFleet::TTimeIntervalValuesAdapter& object) {
    return object.SerializeDataToJson();
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDedicatedFleet::TCommonFleetValuesAdapter& result) {
    return result.DeserializeDataFromJson(value);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDedicatedFleet::TCommonFleetValuesAdapter& object) {
    return object.SerializeDataToJson();
}

template <>
bool NJson::TryFromJson(const NJson::TJsonValue& value, NDedicatedFleet::TOptionValuesAdapter& result) {
    return result.DeserializeDataFromJson(value);
}

template <>
NJson::TJsonValue NJson::ToJson(const NDedicatedFleet::TOptionValuesAdapter& object) {
    return object.SerializeDataToJson();
}


NDrive::TScheme TTimeIntervalValues::TConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSDuration>("prepare_duration", "Время необходимое для подготовки парка(от даты создания заявки)").SetDefault(PrepareDuration).SetRequired(true);
    scheme.Add<TFSDuration>("min_duration", "Минимальная продолжительность владения парком(дни)").SetDefault(MinDuration).SetRequired(true);
    scheme.Add<TFSDuration>("max_duration", "Максимальная продолжительность владения парком(дни)").SetDefault(MaxDuration).SetRequired(true);
    scheme.Add<TFSDuration>("farthest_start", "Количество дней доступных для оформления заявки от текущей даты").SetDefault(FarthestStart).SetRequired(true);
    return scheme;
}

NDrive::TScheme TTimeIntervalValues::TStringConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSString>("start_title", "Заголовок начала").SetDefault(StartTitle);
    scheme.Add<TFSString>("end_title", "Заголовок завершения").SetDefault(EndTitle);
    scheme.Add<TFSString>("duration_title", "Заголовок срока аренды").SetDefault(DurationTitle);
    scheme.Add<TFSString>("minimal_duration_text", "Текст минимально срока аренды").SetDefault(MinimalDurationText);
    return scheme;
}

template<>
TVector<NJson::TJsonValue> TTimeIntervalValuesAdapter::GetReport(ELocalization locale, const NDrive::IServer& server) const {
    TVector<NJson::TJsonValue> reports;
    reports.reserve(3);
    {
        TOfferVariable<ui64> result;
        result.SetId("start_ts");
        if (StringConstants.Defined()) {
            result.SetTitle(StringConstants.GetRef().GetStartTitle());
        }

        result.SetDefaultValue(GetClosestBeginInstant().Seconds());
        result.SetMinimalValue(GetClosestBeginInstant().Seconds());
        result.SetMaximalValue(GetFarthestBeginInstant().Seconds());

        if (HasBeginTime()) {
            result.SetValue(GetBeginTimeRef().Seconds());
        }

        reports.emplace_back(result.GetReport(locale, server));
    }
    {
        TOfferVariable<ui64> result;
        result.SetId("end_ts");
        if (StringConstants.Defined()) {
            result.SetTitle(StringConstants.GetRef().GetEndTitle());
        }

        result.SetDefaultValue(GetClosestEndInstant().Seconds());
        result.SetMinimalValue(GetClosestEndInstant().Seconds());
        result.SetMaximalValue(GetFarthestEndInstant().Seconds());

        if (HasEndTime()) {
            result.SetValue(GetEndTimeRef().Seconds());
        }

        reports.emplace_back(result.GetReport(locale, server));
    }
    {
        TOfferVariable<ui64> result;
        result.SetId("duration");
        if (StringConstants.Defined()) {
            result.SetTitle(StringConstants.GetRef().GetDurationTitle());
            result.SetSubtitle(StringConstants.GetRef().GetMinimalDurationText());
        }

        if (HasDuration()) {
            result.SetValue(GetDurationRef().Seconds());
        }

        reports.emplace_back(result.GetReport(locale, server));
    }

    return reports;
}

template<> template<>
bool TTimeIntervalValuesAdapter::DeserializeFromProto(const NDrive::NProto::TDedicatedFleetOffer& offer) {
    if (!offer.HasTimeInterval()) {
        return true;
    }

    const auto& time = offer.GetTimeInterval();
    if (time.HasConstants()) {
        const auto& proto = time.GetConstants();
        auto& res = Constants.ConstructInPlace();
        if (proto.HasAvailableSince()) {
            res.SetAvailableSince(TInstant::MicroSeconds(proto.GetAvailableSince()));
        }

        if (proto.HasAvailableUntil()) {
            res.SetAvailableUntil(TInstant::MicroSeconds(proto.GetAvailableUntil()));
        }

        if (proto.HasPrepareDuration()) {
            res.SetPrepareDuration(TDuration::MicroSeconds(proto.GetPrepareDuration()));
        }

        if (proto.HasMinDuration()) {
            res.SetMinDuration(TDuration::MicroSeconds(proto.GetMinDuration()));
        }

        if (proto.HasMaxDuration()) {
            res.SetMaxDuration(TDuration::MicroSeconds(proto.GetMaxDuration()));
        }

        if (proto.HasAvailableSince()) {
            res.SetAvailableSince(TInstant::MicroSeconds(proto.GetAvailableSince()));
        }

        if (proto.HasAvailableUntil()) {
            res.SetAvailableUntil(TInstant::MicroSeconds(proto.GetAvailableUntil()));
        }

        if (proto.HasDefaultDuration()) {
            res.SetDefaultDuration(TDuration::MicroSeconds(proto.GetDefaultDuration()));
        }
    }

    if (time.HasBeginTime()) {
        SetBeginTime(TInstant::MicroSeconds(time.GetBeginTime()));
    }

    if (time.HasEndTime()) {
        SetEndTime(TInstant::MicroSeconds(time.GetEndTime()));
    }

    if (time.HasDuration()) {
        SetDuration(TDuration::MicroSeconds(time.GetDuration()));
    }

    return true;
}

template<> template<>
bool TTimeIntervalValuesAdapter::SerializeToProto(NDrive::NProto::TDedicatedFleetOffer& offer) const {
    auto& result = *offer.MutableTimeInterval();
    if (Constants.Defined()) {
        auto& proto = *result.MutableConstants();
        proto.SetAvailableSince(Constants->GetAvailableSince().MicroSeconds());
        proto.SetAvailableUntil(Constants->GetAvailableUntil().MicroSeconds());
        proto.SetPrepareDuration(Constants->GetPrepareDuration().MicroSeconds());
        proto.SetMinDuration(Constants->GetMinDuration().MicroSeconds());
        proto.SetMaxDuration(Constants->GetMaxDuration().MicroSeconds());
        proto.SetFarthestStart(Constants->GetFarthestStart().MicroSeconds());
        proto.SetDefaultAvailableSince(Constants->GetDefaultAvailableSince().MicroSeconds());
        proto.SetDefaultAvailableUntil(Constants->GetDefaultAvailableUntil().MicroSeconds());
        proto.SetDefaultDuration(Constants->GetDefaultDuration().MicroSeconds());
    }

    if (HasBeginTime()) {
        result.SetBeginTime(GetBeginTimeRef().MicroSeconds());
    }

    if (HasEndTime()) {
        result.SetEndTime(GetEndTimeRef().MicroSeconds());
    }

    if (HasDuration()) {
        result.SetDuration(GetDurationRef().MicroSeconds());
    }

    return true;
}


NDrive::TScheme TCommonFleetValues::TConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSNumeric>("default_size", "Количество по умолчанию").SetDefault(DefaultSize);
    scheme.Add<TFSNumeric>("min_size", "Минимальное количество машин в парке").SetDefault(MinSize);
    scheme.Add<TFSNumeric>("max_size", "Максимальное количество машин в парке").SetDefault(MaxSize);
    return scheme;
}

NDrive::TScheme TCommonFleetValues::TStringConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSString>("placeholder_text", "Текст поля без значения").SetDefault(PlaceholderText);
    scheme.Add<TFSString>("available_text", "Шаблон текста доступного количества").SetDefault(AvailableText);
    return scheme;
}

template<>
TVector<NJson::TJsonValue> TCommonFleetValuesAdapter::GetReport(ELocalization locale, const NDrive::IServer& server) const {
    TOfferVariable<ui64> result;
    result.SetId("cars_counter");
    if (StringConstants.Defined()) {
        result.SetTitle(StringConstants.GetRef().GetPlaceholderText());
    }

    result.OptionalDefaultValue() = OptionalDefaultSize();
    result.OptionalMinimalValue() = OptionalMinSize();
    result.OptionalMaximalValue() = OptionalMaxSize();
    result.OptionalValue() = OptionalSize();

    return {std::move(result.GetReport(locale, server))};
}

template<> template<>
bool TCommonFleetValuesAdapter::DeserializeFromProto(const NDrive::NProto::TDedicatedFleetOffer& offer) {
     if (!offer.HasFleet()) {
        return true;
    }

    const auto& info = offer.GetFleet();
    if (info.HasConstants()) {
        const auto& proto = info.GetConstants();
        auto& res = Constants.ConstructInPlace();
        if (proto.HasMaxSize()) {
            res.SetMaxSize(proto.GetMaxSize());
        }

        if (proto.HasMinSize()) {
            res.SetMinSize(proto.GetMinSize());
        }

        if (proto.HasDefault()) {
            res.SetDefaultSize(proto.GetDefault());
        }
    }

    if (info.HasSize()) {
        SetSize(info.GetSize());
    }

    return true;
}

template<> template<>
bool TCommonFleetValuesAdapter::SerializeToProto(NDrive::NProto::TDedicatedFleetOffer& offer) const {
    auto& result = *offer.MutableFleet();
    if (Constants.Defined()) {
        auto& proto = *result.MutableConstants();
        proto.SetMaxSize(Constants->GetMaxSize());
        proto.SetMinSize(Constants->GetMinSize());
        proto.SetDefault(Constants->GetDefaultSize());
    }

    if (HasSize()) {
        result.SetSize(GetSizeRef());
    }

    return true;
}


NDrive::TScheme TOptionValues::TConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSBoolean>("default_value", "Значение по умолчанию").SetDefault(false);
    scheme.Add<TFSString>("id", "Идентификатор опции").SetRequired(true);
    scheme.Add<TFSNumeric>("cost", "Цена за единицу(копейки)");
    scheme.Add<TFSVariants>(TString(CalculatePolicyNameId), "Тип калькуляции")
        .InitVariants<ECostCalculatePolicy>()
        .SetDefault(::ToString(ECostCalculatePolicy::None))
        .SetRequired(true);
    return scheme;
}

NDrive::TScheme TOptionValues::TStringConstants::GetScheme(const NDrive::IServer* /*server*/) const {
    NDrive::TScheme scheme;
    scheme.Add<TFSString>("title", "Заголовок опции").SetRequired(true);
    scheme.Add<TFSString>("subtitle", "Подзаголовок опции(серый шрифт)");
    scheme.Add<TFSString>("unit", "Единицы измерения");
    return scheme;
}

template<>
TVector<NJson::TJsonValue> TOptionValuesAdapter::GetReport(ELocalization locale, const NDrive::IServer& server) const {
    TOfferVariable<ui64> result;
    if (Constants.Defined()) {
        const auto& constants = Constants.GetRef();
        result.SetId(constants.GetId());
        result.SetDefaultValue(constants.GetDefaultValue());
        result.SetCost(constants.GetCost());
    }

    if (StringConstants.Defined()) {
        const auto& strConstants = StringConstants.GetRef();
        result.SetTitle(strConstants.GetTitle());
        result.SetUnit(strConstants.GetUnits());
    }

    if (HasValue()) {
        result.SetValue(GetValueRef());
    }

    return {std::move(result.GetReport(locale, server))};
}

template<> template<>
bool TOptionValuesAdapter::DeserializeFromProto(const NDrive::NProto::TDedicatedFleetUnitOffer_TOption& option) {
    if (option.HasValue()) {
        const auto& proto = option.GetValue();
        if (proto.HasBoolValue()) {
            SetValue(proto.GetBoolValue());
        }
    }

    if (option.HasConstants()) {
        auto& res = Constants.ConstructInPlace();
        const auto& proto = option.GetConstants();
        if (proto.HasId()) {
            res.SetId(proto.GetId());
        }

        if (proto.HasDefaultValue()) {
            auto valProto = proto.GetDefaultValue();
            if (valProto.HasBoolValue()) {
                res.SetDefaultValue(valProto.GetBoolValue());
            }
        }

        if (proto.HasCost()) {
            res.SetCost(proto.GetCost());
        }

        if (proto.HasCalculatePolicy()) {
            res.SetCalculatePolicy(::FromString(proto.GetCalculatePolicy()));
        }
    }

    if (option.HasStringConstants()) {
        auto& res = StringConstants.ConstructInPlace();
        const auto& proto = option.GetStringConstants();

        if (proto.HasTitle()) {
            res.SetTitle(proto.GetTitle());
        }

        if (proto.HasSubtitle()) {
            res.SetSubtitle(proto.GetSubtitle());
        }

        if (proto.HasUnits()) {
            res.SetUnits(proto.GetUnits());
        }
    }

    return true;
}

template<> template<>
bool TOptionValuesAdapter::SerializeToProto(NDrive::NProto::TDedicatedFleetUnitOffer_TOption& option) const {
    if (Constants.Defined()) {
        auto& proto = *option.MutableConstants();
        proto.SetId(Constants->GetId());
        auto& protoDef = *proto.MutableDefaultValue();
        protoDef.SetBoolValue(Constants->GetDefaultValue());
        proto.SetCost(Constants->GetCost());
        proto.SetCalculatePolicy(::ToString(Constants->GetCalculatePolicy()));
    }

    if (StringConstants.Defined()) {
        auto& proto = *option.MutableStringConstants();
        proto.SetTitle(StringConstants.GetRef().GetTitle());
        proto.SetSubtitle(StringConstants.GetRef().GetSubtitle());
        proto.SetUnits(StringConstants.GetRef().GetUnits());
    }

    if (HasValue()) {
        auto& proto = *option.MutableValue();
        proto.SetBoolValue(GetValueRef());
    }

    return true;
}
