#pragma once

#include <drive/backend/offers/actions/abstract.h>
#include <drive/backend/offers/actions/standart.h>
#include <drive/backend/offers/actions/helpers.h>

#include <rtline/library/geometry/polyline.h>

#include <util/generic/yexception.h>

namespace NDrive::NProto {
    class TStandardWithDiscountAreaOffer;
    class TOffer;
}

class TStandardWithDiscountAreaOfferState: public TStandartOfferState {
private:
    using TBase = TStandartOfferState;

private:
    R_FIELD(bool, IsDiscountedState, false);
    R_FIELD(bool, InFinishPolygon, false);

public:
    TStandardWithDiscountAreaOfferState() = default;
    TStandardWithDiscountAreaOfferState(const TStandartOfferState& state)
        : TBase(state)
    {
    }
};

bool IsCurrentSession(const TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent>& timeline);

class TStandardWithDiscountAreaOffer : public TStandartOffer {
private:
    using TBase = TStandartOffer;

    static TFactory::TRegistrator<TStandardWithDiscountAreaOffer> Registrator;

protected:
    TOfferStatePtr Calculate(const TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& events, const TInstant& until, TOfferPricing& result) const override;
    NJson::TJsonValue DoBuildJsonReport(const TReportOptions& options, const ICommonOfferBuilderAction* constructor, const NDrive::IServer& server) const override;
    void FillBill(TBill& bill, const TOfferPricing& pricing, TOfferStatePtr segmentState, ELocalization locale, const NDrive::IServer* server, ui32 cashbackPercent) const override;

private:
    bool IsInFinishPolygon(const TVector<IEventsSession<TCarTagHistoryEvent>::TTimeEvent>& timeline, const TVector<TAtomicSharedPtr<TCarTagHistoryEvent>>& events, const TInstant& until) const;

public:
    using TBase::TBase;

    static const TString TypeName;

    TStandardWithDiscountAreaOffer() = default;
    TStandardWithDiscountAreaOffer(TStandardWithDiscountAreaOffer&& offer) = default;

    // TStandardWithDiscountAreaOffer creates new offer based on StandartOffer.
    TStandardWithDiscountAreaOffer(const TStandartOffer& standart)
        : TBase(ICommonOffer::DeepCopy(standart))
    {
        RebuildDiscountedOffer();
    }

    // RebuildDiscountedOffer should be used after changing any field (or group of fields).
    // You should not apply any calculations before RebuildDiscountedOffer is called.
    void RebuildDiscountedOffer();

    TString GetTypeName() const override {
        return TypeName;
    }

    // After applying model offer must be rebuilt.
    void ApplyDiscountModel(const NDrive::IOfferModel& model);

    bool DeserializeFromProto(const NDrive::NProto::TOffer& info) override;
    NDrive::NProto::TOffer SerializeToProto() const override;

private:
    TStandartOffer DiscountedOffer;
    R_FIELD(TGeoCoord, Finish);
    R_FIELD(TString, FinishName);
    R_FIELD(TVector<TGeoCoord>, FinishArea);
    R_FIELD(TString, FinishAreaId);
    R_FIELD(i32, Discount, 0);
};

class TStandardWithDiscountAreaOfferReport: public IOfferReport {
private:
    using TBase = IOfferReport;

protected:
    TFullPricesContext* GetFullPricesContext() override {
        return GetOfferAs<TFullPricesContext>();
    }

    // TODO: this method will be deleted from inherited interface.
    void DoRecalcPrices(const NDrive::IServer* /*server*/) override {
        return;
    }

public:
    using TBase::TBase;

    using TBaseOffer = TStandardWithDiscountAreaOffer;

    TStandardWithDiscountAreaOfferReport(const IOfferReport& source)
        : TBase(source)
    {
    }

    //will be implemented soon
    void RecalculateFeatures() override {
        return;
    };
};
