#pragma once

#include "price.h"
#include "simple.h"

#include <drive/backend/offers/ranking/features.h>
#include <drive/backend/offers/ranking/model.h>

#include <drive/library/cpp/scheme/scheme.h>

namespace NDrive::NProto {
    class TFullPricesContext;
    class TOfferFeatures;
}

class TMarketPricesContext: public TPricesContext {
private:
    R_FIELD(NDrive::TOfferFeatures, Features);

public:
    bool DeserializeFeatures(const NDrive::NProto::TOfferFeatures& features);
    bool DeserializePricesContextFromProto(const NDrive::NProto::TMarketPricesContext& proto);
    NDrive::NProto::TOfferFeatures SerializeFeatures() const;
    NDrive::NProto::TMarketPricesContext SerializePricesContextToProto(bool serializeFeatures) const;

public:
    static void ApplyPriceModel(TPriceContext& context, const NDrive::IOfferModel& model, NDrive::TOfferFeatures& features, const i32 factorIndexFrom, const i32 factorIndexTo);
};

class TFullPricesContext: public TMarketPricesContext {
private:
    R_FIELD(TEquilibriumPricesContext, Equilibrium);

public:
    void CopyFromFullContext(const TFullPricesContext& base) {
        *this = base;
    }

    bool DeserializePricesContextFromProto(const NDrive::NProto::TFullPricesContext& proto);
    NDrive::NProto::TFullPricesContext SerializePricesContextToProto(bool serializeFeatures) const;

    ui32 CalcPackPrice(const TDuration d, const double distance, const ui32 leasingDayPrice) const;
    ui32 CalcFixPrice(const TDuration d, const double distance) const;
};

class TFullPricesContextBuilder {
protected:
    virtual void DoRecalcPrices(const NDrive::IServer* server) = 0;
    // TODO(iudovin@): Maybe we should remove this method.
    virtual TFullPricesContext* GetFullPricesContext() = 0;

public:
    ~TFullPricesContextBuilder() = default;

    void ApplyModels(const NDrive::IServer* server);
    void ApplyRidingPriceModel(const NDrive::IOfferModel& model);
    void ApplyParkingPriceModel(const NDrive::IOfferModel& model);

    void CalculateFeatures(const NDrive::TOfferFeatures& base);

    void RecalcPrices(const NDrive::IServer* server);
    virtual void RecalculateFeatures() = 0;
};
