#pragma once

#include "price.h"

#include <kernel/daemon/config/daemon_config.h>

template <class T>
bool TLimitedFraction<T>::Deserialize(const TString& limitsInfo) {
    TAnyYandexConfig config;
    if (!limitsInfo || !config.ParseMemory(limitsInfo)) {
        return false;
    }
    if (!config.GetRootSection()) {
        return false;
    }
    Fraction = config.GetRootSection()->GetDirectives().Value("Fraction", Fraction);
    Min = config.GetRootSection()->GetDirectives().Value("Min", Min);
    Max = config.GetRootSection()->GetDirectives().Value("Max", Max);
    LimitViolationMinPolicy = config.GetRootSection()->GetDirectives().Value("MinViolationPolicy", LimitViolationMinPolicy);
    LimitViolationMaxPolicy = config.GetRootSection()->GetDirectives().Value("MaxViolationPolicy", LimitViolationMaxPolicy);
    return Max >= Min;
}
