#include <drive/backend/offers/ranking/calcer.h>
#include <drive/backend/offers/ranking/model.h>

#include <drive/backend/proto/models.pb.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/testing/benchmark/bench.h>

#include <rtline/library/json/builder.h>
#include <rtline/library/json/cast.h>
#include <rtline/util/algorithm/ptr.h>

#include <cmath>


TString DRIVEANALYTICS_256Features = R"(
[
    [
        8.600000381,
        0.9555556178,
        2.261763096,
        2.799999952,
        1.076923132,
        1.335001111,
        55.66846848,
        37.43664932,
        4,
        0.4179745317,
        0.75,
        0.4930000007,
        6.202535629,
        0,
        0,
        0,
        0,
        0,
        0.00976228714,
        0,
        0,
        1,
        0,
        0,
        0,
        5000,
        0,
        0,
        0,
        0,
        0,
        0,
        8.600000381,
        0,
        0,
        0.9606191516
    ],
    [
        "kia_rio_xline",
        "n",
        "Большой Спасоглинищевский переулок"
    ]
]
    )";

auto featuresJson = NJson::ReadJsonFastTree(DRIVEANALYTICS_256Features);
auto features = NJson::FromJson<NDrive::TOfferFeatures>(featuresJson);


Y_NO_INLINE double LuaCalc(NDrive::TLuaModel& luaModel) {
    return luaModel.Calc(features);
}

Y_NO_INLINE double SimpleCalc() {
    return sin(features.Floats2[23]) + log(features.Floats2[7]);
}

Y_CPU_BENCHMARK(TestLuaModelEval, iface) {
    features.Floats2[7] = 37.43664932;
    features.Floats2[23] = 8.600000381;
    auto luaModel = NDrive::TLuaModel("lua_model", "return math.sin(coefs.floats2.InvHistoricalSupply) + math.log(coefs.floats2.Longitude)");
    for(size_t i = 0; i < iface.Iterations(); ++i) {
        Y_DO_NOT_OPTIMIZE_AWAY(LuaCalc(luaModel));
    }
}

Y_CPU_BENCHMARK(TestSimpleModelEval, iface) {
    features.Floats2[7] = 37.43664932;
    features.Floats2[23] = 8.600000381;
    for(size_t i = 0; i < iface.Iterations(); ++i) {
        Y_DO_NOT_OPTIMIZE_AWAY(SimpleCalc());
    }
}
